% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expression_logger.R
\docType{class}
\name{expression_logger}
\alias{expression_logger}
\title{The expression logger.}
\format{An \code{R6} class object.}
\usage{
expression_logger
}
\description{
The expression logger records the result of one or more user-defined
expressions. It can be used, for example to track aggregates (mean, min, max)
of variables as they get processed in the data pipeline.
}
\section{Creating a logger}{

\code{expression_logger$new(..., file="expression_log.csv")}
\tabular{ll}{
\code{...}\tab comma-separated \code{name = expression} pairs\cr
\code{file}\tab [character] filename for temporaty log storage. \cr
}
}

\section{Dump options}{

\code{$dump()}
\tabular{ll}{
  \code{}\tab Currently no options are implemented.
}
}

\examples{

logfile <- file.path(tempfile(fileext=".csv"))
e <- expression_logger$new(mean=mean(height), sd=sd(height),file=logfile)

out <- women \%L>\%
  start_log(e) \%L>\%
  within(height <- height * 2) \%L>\%
  within(height <- height * 3) \%L>\%
  dump_log(stop=TRUE)

read.csv(logfile)


}
\seealso{
Other loggers: \code{\link{cellwise}},
  \code{\link{filedump}}, \code{\link{simple}}
}
\keyword{datasets}
