% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/http.R
\name{ldentities}
\alias{ldentities}
\title{Get Entities}
\usage{
ldentities(query = list(), page = 1, per_page = 10, verbose = TRUE, ...)
}
\arguments{
\item{query}{A list specifying search query parameters. A reasonable default query would be \code{query = list(term = "joe")} to search for entities containing the word \dQuote{joe}.}

\item{page}{A numeric value specifying which page of results to return. Pagination details are stored in the \code{meta} attribute of the response object.}

\item{per_page}{A numeric value specifying the number of entities to return in one page. Pagination details are stored in the \code{meta} attribute of the response object.}

\item{verbose}{A logical (\code{TRUE}, by default) specifying whether to print pagination details to the console.}

\item{...}{Additional arguments passed to \code{\link{lumenHTTP}}.}
}
\value{
A list of objects of class \dQuote{lumen_entity}. The default \code{print} method will display some essential details of each topic.
}
\description{
Get a list of Lumen Database entities matching a query
}
\details{
This function retrieves a list of \dQuote{entities} named in the Lumen Database that match a query. See \href{https://github.com/berkmancenter/lumendatabase/blob/dev/doc/api_documentation.mkd}{API Documentation} for details. Results are paginated by the \code{page} and \code{per_page} arguments.
}
\examples{
\dontrun{
# return entities matching "joe"
ldentities(query = list(term = "joe"))

# use non-default pagination arguments
ldentities(query = list(term = "pub"), page = 3, per_page = 5)
}
}

