% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/http.R
\name{ldsearch}
\alias{ldsearch}
\title{Search Notices}
\usage{
ldsearch(query = list(), page = 1, per_page = 10, verbose = TRUE, ...)
}
\arguments{
\item{query}{A list specifying search query parameters. A reasonable default query would be \code{query = list(term = "joe")} to search for entities containing the word \dQuote{joe}. See \href{https://github.com/berkmancenter/lumendatabase/blob/dev/doc/api_documentation.mkd}{API Documentation} for details of search query terms.}

\item{page}{A numeric value specifying which page of results to return. Pagination details are stored in the \code{meta} attribute of the response object.}

\item{per_page}{A numeric value specifying the number of entities to return in one page. Pagination details are stored in the \code{meta} attribute of the response object.}

\item{verbose}{A logical (\code{TRUE}, by default) specifying whether to print pagination details to the console.}

\item{...}{Additional arguments passed to \code{\link{lumenHTTP}}.}
}
\value{
A list of objects of class \dQuote{lumen_notice}. The default \code{print} method will display some essential details of each topic.
}
\description{
Search for Lumen Database Notices
}
\details{
This function retrieves a list of notices matching a query. Results are paginated by the \code{page} and \code{per_page} arguments. Individual notices can instead be retrieved by their ID using \code{\link{ldnotice}}.
}
\examples{
\dontrun{
# find YouTube-related notices
x <- ldsearch(query = list(term = "youtube"))
str(x, 1)
}
}

