% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lsm.R
\name{plot.lsm}
\alias{plot.lsm}
\title{Two dimensional plot of the Latent Space Model output}
\usage{
\method{plot}{lsm}(x, Y, drawCB = FALSE, dimZ = c(1, 2), colPl = 1,
  colEll = rgb(0.6, 0.6, 0.6, alpha = 0.1), LEVEL = 0.95,
  pchplot = 20, pchEll = 19, pchPl = 19, cexPl = 1.1,
  arrowhead = FALSE, curve = NULL, xlim = NULL, ylim = NULL, ...)
}
\arguments{
\item{x}{object of class \code{'lsm'}}

\item{Y}{(\code{N} x \code{N}) binary adjacency matrix}

\item{drawCB}{draw confidence bounds}

\item{dimZ}{dimensions of the latent variable to be plotted. Default \code{dimZ = c(1, 2)}}

\item{colPl}{\code{col} for the points representing the nodes. Default \code{colPl = NULL}}

\item{colEll}{\code{col} for the ellipses. Default \code{rgb(.6, .6 ,.6 , alpha=.1)}}

\item{LEVEL}{levels of confidence bounds shown when plotting the ellipses. Default \code{LEVEL = .95}}

\item{pchplot}{Default \code{pchplot = 20}}

\item{pchEll}{\code{pch} for the ellipses. Default \code{pchEll = 19}}

\item{pchPl}{\code{pch} for the points representing the nodes. Default \code{pchPl = 19}}

\item{cexPl}{\code{cex} for the points representing the nodes. Default \code{cexPl = 1.1}}

\item{arrowhead}{logical, if the arrowed are to be plotted. Default \code{arrowhead = FALSE}}

\item{curve}{curvature of edges. Default \code{curve = 0}}

\item{xlim}{range for x}

\item{ylim}{range for y}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see \code{\link{par}}).}
}
\description{
Function to plot an object of class \code{'lsm'}
}
\examples{
N <- 20
Y <- network(N, directed = FALSE)[,]

modLSM <- lsm(Y, D = 2) 
plot(modLSM, Y)

# Plot with 95\% CB
plot(modLSM, Y, drawCB = TRUE)
# Plot with 99\% CB
plot(modLSM, Y, drawCB = TRUE, LEVEL = .99)
}
