% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_to_prob.R
\name{prob_to_int}
\alias{prob_to_int}
\title{Transforming a set of probabilities to Multinomial logit regression intercepts}
\usage{
prob_to_int(prob_matrix)
}
\arguments{
\item{prob_matrix}{A matrix with number of states OR categories columns and
number of rows to be determined by the user, with rows summing to one. For
obtaining the set of Multinomial logit regression intercepts of the
complete transition probability matrix gamma or categorical emission
distribution matrix, the number of rows equals the number of states
\code{m}.}
}
\value{
\code{prob_to_int} returns a matrix containing Multinomial logit
  regression intercepts, with the number of columns equal to (number of
  states or categories - 1) and the number of rows equal to the number rows
  specified in the input matrix. The first state / category is assumed to be
  the reference category, hence no intercept is returned for this first
  category.
}
\description{
\code{prob_to_int} transforms a set of state transition or categorical
emission observation probabilities to the corresponding Multinomial logit
regression intercepts. Note that the first category is assumed to be the
reference category, hence no intercept is returned for the first state or
category.
}
\details{
Designed to ease the specification of informative hyper-prior values for the
mean intercepts of the transition probability matrix gamma and categorical
emission distribution(s) of the multilevel hidden Markov model through the
functions \code{\link{prior_gamma}} and \code{\link{prior_emiss_cat}}. No
check is performed on correct specifications of the dimensions.
}
\examples{

# example for transition probability matrix gamma with 3 states
m <- 3
gamma_prob <- matrix(c(0.6, 0.2, 0.2,
                       0.1, 0.8, 0.1,
                       0.1, 0.1, 0.8), ncol = m, nrow = m, byrow = TRUE)
gamma_int <- prob_to_int(gamma_prob)
gamma_int

}
\seealso{
\code{\link{int_to_prob}} for transforming a set of Multinomial
  logit regression intercepts to a probabilities, \code{\link{prior_gamma}}
  and \code{\link{prior_emiss_cat}} for specifying informative hyper-priors
  for the the multilevel hidden Markov model and \code{\link{mHMM}} to fit a
  multilevel hidden Markov model.
}
