% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSleepDataMatrix.R
\name{makeSleepDataMatrix}
\alias{makeSleepDataMatrix}
\title{Make a sleep matrix based on the sleep onset and wake up time}
\usage{
makeSleepDataMatrix(sleepFN, epochOut = 60, impute = TRUE, outputFN)
}
\arguments{
\item{sleepFN}{\code{charcter} The input file name with path of sleep onset and wake up. By default, we use part4_nightsummary_sleep_full.csv under /results/QC folder from GGIR output.}

\item{epochOut}{\code{number}  Epoch size to which acceleration was averaged (seconds) in part 3. Defaut is 60 seconds.}

\item{impute}{\code{logical}  Specify if the missing sleep time was imputed based on the averge sleep onset and wake up time. Default is TRUE.}

\item{outputFN}{\code{character}  The output file name that the nonsleep matrix was wrote to. It includs filename, Date, daysleeper, sleeponset, wakeup, oldDate, sleepwindow, sleepimpute, MIN1, MIN2, ..., MIN1440 for the minutes level data when flag.epochOut=60 seconds.}
}
\value{
Sleep matrix and messages of sleep data. 
\item{     duplicatedays}{Duplicate days of sleep data if exists}
\item{     sleepproblem}{Invalid sleep data if exists}  
\item{     sleep matrix (0/1)}{write the sleep matrix to a csv file specified by outputFN}
}
\description{
Make a sleep matrix (sleep=1 and wake=0) based on the sleep onset and wake up time for the purpose of calculating physical acitivy features during wake up time.
}
