% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag-options.R
\name{flag_options}
\alias{flag_options}
\title{Flag Options}
\usage{
flag_options()
}
\value{
A \code{data.frame} containing flag names, its descriptions, and its
    antonym versions.
}
\description{
Lists flags used by most of IMAP servers.
}
\note{
RFC 2060 lists a set of systems flags, which are presentend and extended
    by this function. We also present a list of negative flags. When using
    \code{verbose = TRUE} in \link{configure_imap} function, flags appear
    with "\\", e.g. "\\Seen". It is important to note that some but not all
    functions that deal with flags also accepts, keywords (words listed by
    flags without starting with "\\"). This is the case of \link{add_flags},
    \link{remove_flags}, and \link{replace_flags}
}
\examples{
\dontrun{

library(mRpostman)
flag_options()

}
}
\references{
Crispin, M., "Internet Message Access Protocol - Version 4rev1",
    RFC 2060, \doi{10.17487/RFC2060}, December 1996,
    \url{https://www.rfc-editor.org/info/rfc2060}.
}
\seealso{
Other options: \code{\link{metadata_options}},
  \code{\link{section_or_field_options}}
}
\concept{options}
