% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-mailboxes.R
\name{list_mailboxes}
\alias{list_mailboxes}
\title{Listing Mailboxes}
\usage{
list_mailboxes(imapconf, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
A \code{list} containing the Mailboxes (root and children).
}
\description{
List Mailboxes from IMAP server.
}
\examples{
\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configureIMAP(url="imaps://imap.gmail.com",
                          username="your_gmail_user",
                          password=rstudioapi::askForPassword()
                         )

# list mailboxes
results <- imapconf \%>\%
  list_mailboxes()

}
}
\seealso{
Other mailbox commands: \code{\link{examine_mailbox}},
  \code{\link{list_server_capabilities}},
  \code{\link{rename_mailbox}},
  \code{\link{select_mailbox}}
}
\concept{mailbox commands}
