% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OR.R
\name{OR}
\alias{OR}
\title{Relational Operators - Helper Functions for Custom Search}
\usage{
OR(..., negate = FALSE)
}
\arguments{
\item{...}{a combination of criteria helper functions with its arguments.}

\item{negate}{If \code{TRUE}, negates the search and seeks for
"NOT search_criterion". Default is \code{FALSE}.}
}
\value{
A search string to be used as a \code{custom_request} parameter in
    \link{custom_search} function.
}
\description{
Allows a combination of criteria helper
    functions such as such as \link{before}, \link{since},
    \link{on}, \link{sent_before}, \link{sent_since}, \link{sent_on},
    \link{flag}, \link{string}, \link{smaller_than}, \link{larger_than},
    \link{younger_than}, or \link{younger_than}, in order to execute a
    multiple criteria custom search.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# search
result <- imapconf \%>\%
    select_mailbox(mbox = "INBOX") \%>\%
    custom_search(custom_request = OR(sent_since(date.char="17-Apr-2019"),
                                      smaller_than(size = 512000, negate = TRUE)
                                     ))
# searches for messages SentSince "17-Apr-2019" OR NOT Smaller Than  512KB.

}

}
\seealso{
Other customsearch helper functions: \code{\link{AND}},
  \code{\link{before}}, \code{\link{flag}},
  \code{\link{larger_than}}, \code{\link{older_than}},
  \code{\link{on}}, \code{\link{sent_before}},
  \code{\link{sent_on}}, \code{\link{sent_since}},
  \code{\link{since}}, \code{\link{smaller_than}},
  \code{\link{string}}, \code{\link{younger_than}}
}
\concept{customsearch helper functions}
