% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/younger-than.R
\name{younger_than}
\alias{younger_than}
\title{Criterion constructor function to be combined in a custom search statement}
\usage{
younger_than(seconds, negate = FALSE)
}
\arguments{
\item{seconds}{An integer specifying the number of seconds to be used as
the search criterion.}

\item{negate}{If \code{TRUE}, negates the search and seeks for "NOT SEARCH
CRITERIA". Default is \code{FALSE}.}
}
\description{
Criterion constructor function to be combined in a custom search statement
}
\note{
To be able to use this functionality, the server must support the
  \code{WITHIN} capability.
}
\examples{
\dontrun{
# select folder & search
con$select_folder(name = "INBOX")
# search for messages containing the string "XYZ@k-state.edu" in the
#   "FROM" field AND those that are YOUNGER than 3600 seconds (1 hour).
res <- con$search(request = AND(string(expr = "XYZ@k-state.edu",
                                      where = "FROM"),
                               younger_than(seconds = 3600)))
}

}
\seealso{
Other custom search: 
\code{\link{AND}()},
\code{\link{ImapCon}},
\code{\link{OR}()},
\code{\link{before}()},
\code{\link{flag}()},
\code{\link{larger_than}()},
\code{\link{older_than}()},
\code{\link{on}()},
\code{\link{sent_before}()},
\code{\link{sent_on}()},
\code{\link{sent_since}()},
\code{\link{since}()},
\code{\link{smaller_than}()},
\code{\link{string}()}
}
\concept{custom search}
