% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure_related_functions.R
\name{read_exposure}
\alias{read_exposure}
\title{Read an exposure matrix from a file.}
\usage{
read_exposure(file, check.names = FALSE)
}
\arguments{
\item{file}{File path to a CSV file containing an exposure matrix, i.e.
the numbers of mutations due to each mutational signature.
Each row corresponds to a mutational signature an each
column corresponds to a tumor or other biological sample.}

\item{check.names}{Passed to \code{read.csv}.
\strong{IMPORTANT}: If \code{TRUE} this will replace the double
colon in identifiers of the form <tumor_type>::<sample_id>
with two periods (i.e. <tumor_type>..<sample_id>.
If \code{check.names} is true, generate a warning
if double colons were present.}
}
\value{
Numerical matrix of exposures, with the same
 shape as the contents of \code{file}.
}
\description{
Read an exposure matrix from a file.
}
\examples{
file <- system.file("extdata",
  "Liver-HCC.exposure.csv",
  package = "mSigTools"
)
exposure <- read_exposure(file)
}
