% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{logistic}
\alias{logistic}
\title{Logistic Regression Models}
\usage{
logistic(data, y, ..., odds_ratio = TRUE, rnd = 3)
}
\arguments{
\item{data}{Dataset}

\item{y}{Dependent variable}

\item{...}{Independent variable or multiple variables}

\item{odds_ratio}{if \code{TRUE}, odds ratios, exponentiated coefficients
are calculated.
Otherwise, coefficients are estimated.}

\item{rnd}{specify rounding of numbers. See \code{\link{round}}.}
}
\value{
A list of two \code{data.frame} and \code{model}
}
\description{
\code{logistic()} produces regression outputs which mirror
outputs from \code{STATA}.
}
\details{
\code{logistic} is based on \code{\link{glm}} with binomial family.
All statistics presented in the function's output are derivates of
\code{\link{glm}},
except AIC value which is obtained from \code{\link{AIC}}.

\strong{Outputs}

Outputs can be divided into three parts.
\enumerate{
\item Information about the model
}

Here provides number of observations (Obs.), chi value from Likelihood Ratio
test (LR chi2) and its degree of freedom, p-value from LR test,
Pseudo R Squared, log likelihood and AIC values.
\enumerate{
\item Regression Output
}

Coefficients from summary of model are tabulated here along with 95\\%
confidence interval.
}
\examples{

## use infert data
data(infert)

## run logistic regression
logistic(infert, case, induced, spontaneous)

## get coefficient instead of odds ratio
logistic(infert, case, induced, spontaneous, odds_ratio = FALSE)

}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
