% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/administered_functions.R
\name{excludeAdministeredItems}
\alias{excludeAdministeredItems}
\title{Update a constraints object to exclude administered items}
\usage{
excludeAdministeredItems(constraints, administered_items)
}
\arguments{
\item{constraints}{a \code{\linkS4class{constraints}} object.}

\item{administered_items}{item names of previously administered items.}
}
\value{
a \code{\linkS4class{constraints}} object that also constrains the administered items to be excluded.
}
\description{
The function \code{\link{excludeAdministeredItems}} produces a new \code{\linkS4class{constraints}} object
that excludes administered items from being selected.
}
\examples{
\dontrun{
require(TestDesign)

cfg <- createShadowTestConfig(
  MIP = list(solver = "lpsymphony")
)
constraints <- constraints_reading
solution <- Shadow(cfg, constraints, true_theta = 0)
administered_items <- solution@output[[1]]@administered_item_index
administered_items <- solution@constraints@pool@id[administered_items]
administered_items

updated_constraints <- excludeAdministeredItems(constraints, administered_items)

solution <- Shadow(cfg, updated_constraints, true_theta = 0)
administered_items <- solution@output[[1]]@administered_item_index
administered_items <- solution@constraints@pool@id[administered_items]
administered_items ## entirely different from above
}
}
