% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_functions.R
\name{loadModules}
\alias{loadModules}
\title{Load multiple modules}
\usage{
loadModules(fn, base_path = NULL, assessment_structure, examinee_list)
}
\arguments{
\item{fn}{the name of a csv file containing module specifications.}

\item{base_path}{(optional) the base path to append before the file paths contained in module specs.}

\item{assessment_structure}{an \code{\linkS4class{assessment_structure}} object.}

\item{examinee_list}{an examinee list from \code{\link{simExaminees}}. Used to determine the range of required modules.}
}
\value{
a module list containing \code{\linkS4class{module}} objects.
Each module can be accessed using \code{module_list[[grade]][[phase]]}.
}
\description{
\code{\link{loadModules}} is a function for creating multiple \code{\linkS4class{module}} objects
from a specification sheet.
}
\details{
The module specification file is expected to have the following columns:
\itemize{
  \item{\code{Grade} a string containing the grade in the form \code{G?}, where \code{?} is a number.}
  \item{\code{Phase} a string containing the phase in the form \code{P?}, where \code{?} is a number.}
  \item{\code{ItemPool} the file path of a file that contains item pool data. This must be readable with \code{\link[TestDesign]{loadItemPool}}.}
  \item{\code{ItemAttrib} the file path of a file that contains item attribute data. This must be readable with \code{\link[TestDesign]{loadItemAttrib}}.}
  \item{\code{PassageAttrib} the file path of a file that contains passage attribute data. This must be readable with \code{\link[TestDesign]{loadStAttrib}}.}
  \item{\code{Constraints} the file path of a file that contains constraints data. This must be readable with \code{\link[TestDesign]{loadConstraints}}.}
}
}
\examples{
assessment_structure <- createAssessmentStructure(
  n_test  = 3,
  n_phase = 2,
  route_limit_below = 0,
  route_limit_above = 2
)
examinee_list <- simExaminees(
  N             = 5,
  mean_v        = c(0, 0, 0),
  sd_v          = c(1, 1, 1),
  cor_v         = diag(1, 3),
  assessment_structure = assessment_structure
)

fn <- system.file("extdata", "module_definition_MATH_normal_N500.csv", package = "maat")
pkg_path <- system.file(package = "maat")
module_list <- loadModules(
  fn,
  base_path = pkg_path,
  assessment_structure = assessment_structure,
  examinee_list = examinee_list
)

}
