% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-multivar.r
\name{mable.mvar}
\alias{mable.mvar}
\title{Maximum Approximate Bernstein Likelihood Estimate
 of Multivariate Density Function}
\usage{
mable.mvar(
  x,
  M0 = 1,
  M,
  search = TRUE,
  interval = NULL,
  use.mar.deg = FALSE,
  criterion = c("cdf", "pdf"),
  controls = mable.ctrl(),
  progress = TRUE
)
}
\arguments{
\item{x}{an \code{n x d} matrix or \code{data.frame} of multivariate sample of size \code{n}}

\item{M0}{a positive integer or a vector of \code{d} positive integers specify
starting candidate degrees for searching optimal degrees.}

\item{M}{a positive integer or a vector of \code{d} positive integers specify
the maximum candidate or the given model degrees for the joint density.}

\item{search}{logical, whether to search optimal degrees between \code{M0} and \code{M} 
or not but use \code{M} as the given model degrees for the joint density.}

\item{interval}{a vector of two endpoints or a \code{d x 2} matrix, each row containing 
the endpoints of support/truncation interval for each marginal density.
If missing, the i-th row is assigned as \code{c(min(x[,i]), max(x[,i]))}.}

\item{use.mar.deg}{logical, if TRUE, the optimal degrees are selected based
on marginal data, otherwise, the optimal degrees are those minimize the maximum
L2 distance between marginal cdf or pdf estimated based on marginal data and the
joint data. See details.}

\item{criterion}{either cdf or pdf should be used for selecting optimal degrees.
Default is "cdf"}

\item{controls}{Object of class \code{mable.ctrl()} specifying iteration limit
and the convergence criterion \code{eps}. Default is \code{\link{mable.ctrl}}. See Details.}

\item{progress}{if TRUE a text progressbar is displayed}
}
\value{
A list with components
\itemize{
 \item \code{m} a vector of the selected optimal degrees by the method of change-point
 \item \code{p} a vector of the mixture proportions \eqn{p(j_1, \ldots, j_d)}, arranged in the 
  column-major order of \eqn{j = (j_1, \ldots, j_d)}, \eqn{0 \le j_i \le m_i, i = 1, \ldots, d}.
 \item \code{mloglik}  the maximum log-likelihood at an optimal degree \code{m}
 \item \code{pval}  the p-values of change-points for choosing the optimal degrees for the 
   marginal densities
 \item \code{M} the vector \code{(m1, m2, ... , md)}, where \code{mi} is the largest candidate 
   degree when the search stoped for the \code{i}-th marginal density
 \item \code{interval} support hyperrectangle \eqn{[a, b]=[a_1, b_1] \times \cdots \times [a_d, b_d]}
 \item \code{convergence} An integer code. 0 indicates successful completion(the EM iteration is   
   convergent). 1 indicates that the iteration limit \code{maxit} had been reached in the EM iteration;
}
}
\description{
Maximum Approximate Bernstein Likelihood Estimate
 of Multivariate Density Function
}
\details{
A \eqn{d}-variate density \eqn{f} on a hyperrectangle \eqn{[a, b]
  =[a_1, b_1] \times \cdots \times [a_d, b_d]} can be approximated 
  by a mixture of \eqn{d}-variate beta densities on \eqn{[a, b]}, 
  \eqn{\beta_{mj}(x) = \prod_{i=1}^d\beta_{m_i,j_i}[(x_i-a_i)/(b_i-a_i)]/(b_i-a_i)},
  with proportion \eqn{p(j_1, \ldots, j_d)}, \eqn{0 \le j_i \le m_i, i = 1, \ldots, d}. 
  Let \eqn{\tilde F_i} (\eqn{\tilde f_i}) be an estimate with degree \eqn{\tilde m_i} of  
  the i-th marginal cdf (pdf) based on marginal data \code{x[,i]}, \eqn{i=1, \ldots, d}. 
  If \code{search=TRUE} and \code{use.marginal=TRUE}, then the optimal degrees
  are \eqn{(\tilde m_1,\ldots,\tilde m_d)}. If \code{search=TRUE} and 
  \code{use.marginal=FALSE}, then the optimal degrees \eqn{(\hat m_1,\ldots,\hat m_d)}
  are those that minimize the maximum of \eqn{L_2}-distance between 
  \eqn{\tilde F_i} (\eqn{\tilde f_i}) and the estimate of \eqn{F_i} (\eqn{f_i}) 
  based on the joint data with degrees \eqn{m=(m_1,\ldots,m_d)} for all \eqn{m}
   between \eqn{M_0} and \eqn{M} if \code{criterion}="cdf" (\code{criterion}="pdf"). 

  For large data and multimodal density, the search for the model degrees is 
  very time-consuming. In this case, it is suggested that the degrees are selected  
  based on marginal data using \code{\link{mable}} or \code{\link{optimable}}.
}
\examples{
## Old Faithful Data
\donttest{
 a<-c(0, 40); b<-c(7, 110)
 ans<- mable.mvar(faithful, M = c(46,19), search =FALSE, interval = cbind(a,b))
 plot(ans, which="density") 
 plot(ans, which="cumulative")
}
}
\references{
Wang, T. and Guan, Z.,(2019) Bernstein Polynomial Model for Nonparametric Multivariate Density,    
   \emph{Statistics}, Vol. 53, no. 2, 321-338
}
\seealso{
\code{\link{mable}}, \code{\link{optimable}}
}
\author{
Zhong Guan <zguan@iusb.edu>
}
\concept{density estimation}
\concept{multivariate Bernstein polynomial model}
\keyword{distribution}
\keyword{multivariate}
\keyword{nonparametric}
