cma.lm <-
function(dat,model.type=c("single","multilevel"),method=c("HL","TS","HL-TS"),delta=NULL,sens.plot=FALSE,
                 interval=c(-0.9,0.9),tol=1e-4,max.itr=500,conf.level=0.95,
                 error.indep=FALSE,error.var.equal=FALSE,Sigma.update=FALSE,var.constraint=FALSE,
                 legend.pos="topright",xlab=expression(delta),ylab=expression(hat(AB)),
                 cex.lab=1,cex.axis=1,lgd.cex=1,lgd.pt.cex=1,plot.delta0=TRUE,...)
  
{
  if(model.type[1]=="single")
  {
    if(is.null(delta))
    {
      delta<-0
    }
    re<-cma.uni.delta(dat,delta=delta,conf.level=conf.level)
    if(sens.plot)
    {
      re.sens<-cma.uni.sens(dat,conf.level=conf.level)
      cma.uni.plot(re.sens,re,delta=NULL,legend.pos=legend.pos,xlab=xlab,ylab=ylab,
                   cex.lab=cex.lab,cex.axis=cex.axis,lgd.cex=lgd.cex,lgd.pt.cex=1,plot.delta0=plot.delta0,...)
    }
  }else
    if(model.type[1]=="multilevel")
    {
      if(is.null(delta))
      {
        if(method[1]=="TS")
        {
          system.time(re1<-optimize(cma.delta.lm.HL,interval=interval,dat=dat,max.itr=0,tol=tol,
                                    error.indep=error.indep,error.var.equal=error.var.equal,Sigma.update=Sigma.update,
                                    var.constraint=var.constraint,maximum=TRUE))
          re<-cma.delta.lm(dat,delta=re1$maximum,max.itr=0,tol=tol,error.indep=error.indep,error.var.equal=error.var.equal,
                           Sigma.update=Sigma.update,var.constraint=var.constraint)
        }else
        {
          system.time(re1<-optimize(cma.delta.lm.HL,interval=interval,dat=dat,max.itr=max.itr,tol=tol,
                                    error.indep=error.indep,error.var.equal=error.var.equal,Sigma.update=Sigma.update,
                                    var.constraint=var.constraint,maximum=TRUE))
          if(method[1]=="HL")
          {
            re<-cma.delta.lm(dat,delta=re1$maximum,max.itr=max.itr,tol=tol,error.indep=error.indep,error.var.equal=error.var.equal,
                             Sigma.update=Sigma.update,var.constraint=var.constraint)
          }
          if(method[1]=="HL-TS")
          {
            re<-cma.delta.lm(dat,delta=re1$maximum,max.itr=0,tol=tol,error.indep=error.indep,error.var.equal=error.var.equal,
                             Sigma.update=Sigma.update,var.constraint=var.constraint)
          }
        }
      }else
      {
        if(method[1]=="TS")
        {
          re<-cma.delta.lm(dat,delta=delta,max.itr=0,tol=tol,error.indep=error.indep,error.var.equal=error.var.equal,
                           Sigma.update=Sigma.update,var.constraint=var.constraint)
        }
        if(method[1]=="HL")
        {
          re<-cma.delta.lm(dat,delta=delta,max.itr=max.itr,tol=tol,error.indep=error.indep,error.var.equal=error.var.equal,
                           Sigma.update=Sigma.update,var.constraint=var.constraint)
        }
      }
    }
  return(re)
}
