% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSources.R
\name{getSources}
\alias{getSources}
\title{getSources}
\usage{
getSources(
  type = NULL,
  packages = getConfig("packages"),
  globalenv = getConfig("globalenv")
)
}
\arguments{
\item{type}{Type of source, either set to "global" "regional", "download", "correct" or
NULL. Global returns all global sources (non-regional), regional returns
sources with regional data, "download" returns source for which a download
function is available, "correct" returns sources for which a correct function
is available and NULL returns all available sources}

\item{packages}{A character vector with packages for which the available Sources/Calculations should be returned}

\item{globalenv}{Boolean deciding whether sources/calculations in the global environment should be included or not}
}
\value{
A vector containing all currently available sources or outputs of
all loaded data processing packages.
}
\description{
These functions can be used to retrieve a list of currently available
sources and outputs (based on the availability of corresponding conversion
functions in the loaded data data processing packages.)
}
\note{
Please be aware that these functions assume that required source files
do exist and are set correctly in the corresponding config file.
}
\examples{

print(getSources())

}
\seealso{
\code{\link{readSource}}, \code{\link{setConfig}}
}
\author{
Jan Philipp Dietrich
}
