\name{lowpass}
\alias{lowpass}
\title{Lowpass Filter}
\description{Filters high frequencies out of a time series. The filter has the structure x'(n) = (x(n-1)+2*x(n)+x(n+1))/4}
\usage{lowpass(x, i=1, fix=NULL)}
\arguments{
  \item{x}{Vector of data points, that should be filtered or MAgPIE object}
  \item{i}{number of iterations the filter should be applied to the data}
  \item{fix}{Fixes the starting and/or ending data point. Default value is \code{NULL} which doesn't fix any point. Available options are: \code{"start"} for fixing the starting point, 
			\code{"end"} for fixing the ending point and \code{"both"} for fixing both ends of the data.}
}
\value{
  The filtered data vector or MAgPIE object
  }
\author{Jan Philipp Dietrich, Misko Stevanovic}
\examples{
lowpass(c(1,2,11,3,4))
# to fix the starting point
lowpass(c(0,9,1,5,14,20,6,11,0), i=2, fix="start")
}