% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDim.R
\name{getDim}
\alias{getDim}
\title{getDim}
\usage{
getDim(elems, x, fullmatch = FALSE, dimCode = TRUE)
}
\arguments{
\item{elems}{A vector of characters containing the elements that should be
found in the MAgPIE object}

\item{x}{MAgPIE object in which elems should be searched for.}

\item{fullmatch}{If enabled, only dimensions which match exactly the elements
provided will be returned. Otherwise, it is sufficient if elems contains a subset
of the dimension.}

\item{dimCode}{If enabled, the dimCode will be returned, otherwise the name
of the dimension.}
}
\value{
The name or dimCode of the dimensions in which elems were found.
}
\description{
Function which tries to detect the dimension to which the given elems belong
}
\examples{

 data(population_magpie)
 getDim(c("AFR","CPA"),population_magpie)
 getDim(c("AFR","CPA"),population_magpie,fullmatch=TRUE)
 getDim(c("AFR","CPA"),population_magpie,dimCode=FALSE)
 
}
\seealso{
\code{\link{mcalc}},\code{\link{dimCode}}
}
\author{
Jan Philipp Dietrich
}
