\name{free.energy}
\Rdversion{1.1}
\alias{free.energy}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Compute the Free Energy of A Micro-spin System
}
\description{
  This function computes the free energy for a given evolution object
  and the corresponding external magnetic field.
}
\usage{
free.energy(g, h.ext=NULL, ext = FALSE, ext.field = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{g}{
    an evolution object generated by \code{\link{multispin.evol}}
  }
  \item{h.ext}{
    the external magnetic field used in \code{\link{multispin.evol}} to
    generate the evolution object
  }
  \item{ext}{
    whether to include the interaction between the fixed external
    magnets and the system internal magnets
  }
  \item{ext.field}{
    whether to include the interaction between the external magnets and
    the external magnetic field, requiring the external field to be
    uniform for all spins
}
}
\details{

  \strong{(It is much better to view the this section in the PostScript version
  of this documentation. To do that, just run "help (multispin.evol,
    offline=TRUE)" in R command line and you will find "free.energy.ps" in the current working directory.)}
  
  The free energy of a set interacting micro-spins is given by
  
  \deqn{f=-\sum_i\bold{h}_{ext}^{(i)}\cdot\bold{m}^{(i)} + \frac{1}{2}\sum_i\bold{m}^{(i)}\cdot\mathcal{N}_{eff}^{(i)}\cdot
      \bold{m}^{(i)} - \frac{1}{2}\sum_{i,j} \bold{m}^{(i)}\cdot\mathcal{C}_{ij}\cdot\bold{m}^{(j)} +
      k_2\sum_i\sum_{\alpha=x,y,z}m_{\alpha}^2\left(1-\frac{1}{2}m_{\alpha}^2\right)}{f
      = -sum(h_ext m_i) + 0.5 sum(m_i N m_i) - 0.5 sum (m_i C_ij m_j) +
      k2 sum(m_ia^2 (1-m_ia^2))}

    For a detailed explanation for all the quantities in the above
    equation, please refer to \code{\link{multispin.evol}}.
  
}
\value{
  This function returns a \eqn{T\times 2}{(T x 2)} array with the first
  column being the time (\eqn{\mbox{record.list}\times dt}{(record.list
    x dt)}), and the second column being the free energy of the
  system. The result is given a class attribution "free.energy".
}
\references{
  check out the references in \code{\link{multispin.evol}}
}
\author{
  Hai Qian, Electrical Engineering Department, UCLA
}

\seealso{
  \code{\link{multispin.evol}} to simulate a micro-spin system and
  generate an evolution as the result and check out the examples there
  
  \code{\link{single.spin.energy}} to compute the free energy of a
  single isolated spin given the magnetization, effective
  demagnetization tensor, external magnetic field and the biaxial
  anisotropy parameter

  \code{\link{plot.free.energy}} to plot the free.energy object
  generated by this function

  \code{\link{spin.energy.config}} to compute and plot the free energy
  v.s. the angle away from x-axis assuming the magnetization direction
  in always in x-y plane
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~IO }

