% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{process_agd}
\alias{process_agd}
\title{Pre-process aggregate data}
\usage{
process_agd(raw_agd)
}
\arguments{
\item{raw_agd}{raw aggregate data should contain STUDY, ARM, and N. Variable names should be followed
by legal suffixes (i.e. MEAN, MEDIAN, SD, COUNT, or PROP).}
}
\value{
pre-processed aggregate level data
}
\description{
This function checks the format of the aggregate data.
Data is required to have three columns: STUDY, ARM, and N.
Column names that do not have legal suffixes (MEAN, MEDIAN, SD, COUNT, or PROP) are dropped.
If a variable is a count variable, it is converted to proportions by dividing the sample size (N).
Note, when the count is specified, proportion is always calculated based on the count, that is,
specified proportion will be ignored if applicable.
If the aggregated data comes from multiple sources (i.e. different analysis population) and
sample size differs for each variable, one option is to specify proportion directly instead of count by using suffix
_PROP.
}
\examples{
data(agd)
agd <- process_agd(agd)

}
