% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sample_geneology_varying_size}
\alias{sample_geneology_varying_size}
\title{Simulate a geneology with varying population size.}
\usage{
sample_geneology_varying_size(
  population_sizes,
  generations_full = 1L,
  generations_return = 3L,
  enable_gamma_variance_extension = FALSE,
  gamma_parameter_shape = 5,
  gamma_parameter_scale = 1/5,
  progress = TRUE
)
}
\arguments{
\item{population_sizes}{The size of the population at each generation, \code{g}.
\code{population_sizes[g]} is the population size at generation \code{g}.
The length of population_sizes is the number of generations being simulated.}

\item{generations_full}{Number of full generations to be simulated.}

\item{generations_return}{How many generations to return (pointers to) individuals for.}

\item{enable_gamma_variance_extension}{Enable symmetric Dirichlet (and disable standard Wright-Fisher).}

\item{gamma_parameter_shape}{Parameter related to symmetric Dirichlet distribution for each man's probability to be father. Refer to details.}

\item{gamma_parameter_scale}{Parameter realted to symmetric Dirichlet distribution for each man's probability to be father. Refer to details.}

\item{progress}{Show progress.}
}
\value{
A malan_simulation / list with the following entries:
\itemize{
\item \code{population}. An external pointer to the population.
\item \code{generations}. Generations actually simulated, mostly useful when parameter \code{generations = -1}.
\item \code{founders}. Number of founders after the simulated \code{generations}.
\item \code{growth_type}. Growth type model.
\item \code{sdo_type}. Standard deviation in a man's number of male offspring. StandardWF or GammaVariation depending on \code{enable_gamma_variance_extension}.
\item \code{end_generation_individuals}. Pointers to individuals in end generation.
\item \code{individuals_generations}. Pointers to individuals in last \code{generations_return} generation (if \code{generations_return = 3}, then individuals in the last three generations are returned).
}
}
\description{
This function simulates a geneology with varying population size specified
by a vector of population sizes, one for each generation.
}
\details{
By the backwards simulating process of the Wright-Fisher model,
individuals with no descendants in the end population are not simulated
If for some reason additional full generations should be simulated,
the number can be specified via the \code{generations_full} parameter.
This can for example be useful if one wants to simulate the
final 3 generations although some of these may not get (male) children.

Let \eqn{\alpha} be the parameter of a symmetric Dirichlet distribution
specifying each man's probability to be the father of an arbitrary
male in the next generation. When \eqn{\alpha = 5}, a man's relative probability
to be the father has 95\\% probability to lie between 0.32 and 2.05, compared with a
constant 1 under the standard Wright-Fisher model and the standard deviation in
the number of male offspring per man is 1.10 (standard Wright-Fisher = 1).

This symmetric Dirichlet distribution is implemented by drawing
father (unscaled) probabilities from a Gamma distribution with
parameters \code{gamma_parameter_shape} and \code{gamma_parameter_scale}
that are then normalised to sum to 1.
To obtain a symmetric Dirichlet distribution with parameter \eqn{\alpha},
the following must be used:
\eqn{`gamma_parameter_shape` = \alpha}
and
\eqn{`gamma_parameter_scale` = 1/\alpha}.
}
\examples{
sim <- sample_geneology_varying_size(10*(1:10))
str(sim, 1)
sim$population
peds <- build_pedigrees(sim$population)
peds

}
\seealso{
\code{\link[=sample_geneology]{sample_geneology()}}.
}
