/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.geom;

import java.awt.Point;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.apache.log4j.Category;
import salvo.jesus.geom.MultipleIntersectionException;

public class Intersection {
    static Category logger = Category.getInstance((String)(class$salvo$jesus$geom$Intersection == null ? (class$salvo$jesus$geom$Intersection = Intersection.class$("salvo.jesus.geom.Intersection")) : class$salvo$jesus$geom$Intersection).getName());
    static /* synthetic */ Class class$salvo$jesus$geom$Intersection;

    public static Point getIntersection(Line2D line1, Line2D line2) throws MultipleIntersectionException {
        if (!line1.intersectsLine(line2)) {
            return null;
        }
        double x1line1 = line1.getX1();
        double y1line1 = line1.getY1();
        double x2line1 = line1.getX2();
        double y2line1 = line1.getY2();
        double x1line2 = line2.getX1();
        double y1line2 = line2.getY1();
        double x2line2 = line2.getX2();
        double y2line2 = line2.getY2();
        if (x1line1 == x1line2 && y1line1 == y1line2) {
            return new Point((int)x1line1, (int)y1line1);
        }
        if (x1line1 == x2line2 && y1line1 == y2line2) {
            return new Point((int)x1line1, (int)y1line1);
        }
        if (x2line1 == x1line2 && y2line1 == y1line2) {
            return new Point((int)x2line1, (int)y2line1);
        }
        if (x2line1 == x2line2 && y2line1 == y2line2) {
            return new Point((int)x2line1, (int)y2line1);
        }
        double dyline1 = -(y2line1 - y1line1);
        double dxline1 = x2line1 - x1line1;
        double dyline2 = -(y2line2 - y1line2);
        double dxline2 = x2line2 - x1line2;
        double e = -(dyline1 * x1line1) - dxline1 * y1line1;
        double f = -(dyline2 * x1line2) - dxline2 * y1line2;
        if (dyline1 * dxline2 - dyline2 * dxline1 == 0.0) {
            throw new MultipleIntersectionException();
        }
        return new Point((int)(-(e * dxline2 - dxline1 * f) / (dyline1 * dxline2 - dyline2 * dxline1)), (int)(-(dyline1 * f - dyline2 * e) / (dyline1 * dxline2 - dyline2 * dxline1)));
    }

    public static Point getIntersection(Line2D line, GeneralPath path) {
        Line2D.Double rectline = new Line2D.Double();
        Point intersectpoint = null;
        Point testintersectpoint = null;
        Point lineorigin = new Point((int)line.getX1(), (int)line.getY1());
        double[] coords = new double[6];
        double prevx = -1.0;
        double prevy = -1.0;
        FlatteningPathIterator pathiterator = new FlatteningPathIterator(path.getPathIterator(null), 1.0);
        while (!pathiterator.isDone()) {
            int segmenttype = pathiterator.currentSegment(coords);
            switch (segmenttype) {
                case 0: {
                    prevx = coords[0];
                    prevy = coords[1];
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    if (prevx != -1.0 && prevy != 1.0) {
                        rectline.setLine(prevx, prevy, coords[0], coords[1]);
                        try {
                            testintersectpoint = Intersection.getIntersection(line, rectline);
                        }
                        catch (MultipleIntersectionException ex) {
                            logger.error((Object)"Multiple Intersections Detected", (Throwable)ex);
                            testintersectpoint = null;
                        }
                        if (testintersectpoint != null) {
                            Point previousintersectpoint = intersectpoint;
                            intersectpoint = testintersectpoint;
                            if (previousintersectpoint != null && lineorigin.distance(intersectpoint) > lineorigin.distance(previousintersectpoint)) {
                                intersectpoint = previousintersectpoint;
                            }
                        }
                    }
                    prevx = coords[0];
                    prevy = coords[1];
                }
            }
            pathiterator.next();
        }
        return intersectpoint;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

