/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.extract.StringTokenization;
import cc.mallet.grmm.learning.GenericAcrfData2TokenSequence;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.iterator.LineGroupIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelsSequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.types.tests.TestSerializable;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestGenericAcrfData2TokenSequence
extends TestCase {
    String sampleData = "LBLA LBLC ---- f1 f5 f7\nLBLB LBLC ---- f5 f6\nLBLB LBLD ----\nLBLA LBLD ---- f2 f1\n";
    String sampleData2 = "LBLB LBLD ---- f1 f5 f7\nLBLA LBLC ---- f5 f6\nLBLA LBLC ----\nLBLB LBLD ---- f2 f1\n";
    String sampleFixedData = "LBLA LBLC f1 f5 f7\nLBLB LBLC f5 f6\nLBLB LBLD\nLBLA LBLD f2 f1\n";
    String sampleFixedData2 = "LBLB LBLD f1 f5 f7\nLBLA LBLC f5 f6\nLBLA LBLC\nLBLB LBLD f2 f1\n";
    String labelsAtEndData = "f1 f5 f7 LBLB LBLD\nf5 f6 LBLA LBLC\nLBLA LBLC\nf2 f1 LBLB LBLD\n";

    public TestGenericAcrfData2TokenSequence(String name) {
        super(name);
    }

    public void testFromSerialization() throws IOException, ClassNotFoundException {
        GenericAcrfData2TokenSequence p = new GenericAcrfData2TokenSequence();
        InstanceList training = new InstanceList(p);
        training.addThruPipe(new LineGroupIterator(new StringReader(this.sampleData), Pattern.compile("^$"), true));
        Pipe p2 = (Pipe)TestSerializable.cloneViaSerialization(p);
        InstanceList l1 = new InstanceList(p);
        l1.addThruPipe(new LineGroupIterator(new StringReader(this.sampleData2), Pattern.compile("^$"), true));
        InstanceList l2 = new InstanceList(p2);
        l2.addThruPipe(new LineGroupIterator(new StringReader(this.sampleData2), Pattern.compile("^$"), true));
        TestGenericAcrfData2TokenSequence.assertTrue((p.getTargetAlphabet() != p2.getTargetAlphabet() ? 1 : 0) != 0);
        TestGenericAcrfData2TokenSequence.assertEquals((int)1, (int)l1.size());
        TestGenericAcrfData2TokenSequence.assertEquals((int)1, (int)l2.size());
        Instance inst1 = (Instance)l1.get(0);
        Instance inst2 = (Instance)l2.get(0);
        LabelsSequence ls1 = (LabelsSequence)inst1.getTarget();
        LabelsSequence ls2 = (LabelsSequence)inst2.getTarget();
        TestGenericAcrfData2TokenSequence.assertEquals((int)4, (int)ls1.size());
        TestGenericAcrfData2TokenSequence.assertEquals((int)4, (int)ls2.size());
        for (int i = 0; i < 4; ++i) {
            TestGenericAcrfData2TokenSequence.assertEquals((String)ls1.get(i).toString(), (String)ls2.get(i).toString());
        }
    }

    public void testFixedNumLabels() throws IOException, ClassNotFoundException {
        GenericAcrfData2TokenSequence p = new GenericAcrfData2TokenSequence(2);
        InstanceList training = new InstanceList(p);
        training.addThruPipe(new LineGroupIterator(new StringReader(this.sampleFixedData), Pattern.compile("^$"), true));
        TestGenericAcrfData2TokenSequence.assertEquals((int)1, (int)training.size());
        Instance inst1 = (Instance)training.get(0);
        LabelsSequence ls1 = (LabelsSequence)inst1.getTarget();
        TestGenericAcrfData2TokenSequence.assertEquals((int)4, (int)ls1.size());
    }

    public void testLabelsAtEnd() throws IOException, ClassNotFoundException {
        GenericAcrfData2TokenSequence p = new GenericAcrfData2TokenSequence(2);
        p.setLabelsAtEnd(true);
        InstanceList training = new InstanceList(p);
        training.addThruPipe(new LineGroupIterator(new StringReader(this.labelsAtEndData), Pattern.compile("^$"), true));
        TestGenericAcrfData2TokenSequence.assertEquals((int)1, (int)training.size());
        Instance inst1 = (Instance)training.get(0);
        StringTokenization toks = (StringTokenization)inst1.getData();
        LabelsSequence ls1 = (LabelsSequence)inst1.getTarget();
        TestGenericAcrfData2TokenSequence.assertEquals((int)4, (int)ls1.size());
        TestGenericAcrfData2TokenSequence.assertEquals((int)3, (int)((Token)toks.get(0)).getFeatures().size());
        TestGenericAcrfData2TokenSequence.assertEquals((String)"LBLB LBLD", (String)ls1.getLabels(0).toString());
        LabelAlphabet globalDict = p.getLabelAlphabet(0);
        TestGenericAcrfData2TokenSequence.assertEquals((int)2, (int)p.numLevels());
        TestGenericAcrfData2TokenSequence.assertEquals((Object)globalDict, (Object)ls1.getLabels(0).get(0).getLabelAlphabet());
    }

    public void testNoTokenText() {
        GenericAcrfData2TokenSequence p = new GenericAcrfData2TokenSequence(2);
        p.setFeaturesIncludeToken(false);
        p.setIncludeTokenText(false);
        InstanceList training = new InstanceList(p);
        training.addThruPipe(new LineGroupIterator(new StringReader(this.sampleFixedData), Pattern.compile("^$"), true));
        TestGenericAcrfData2TokenSequence.assertEquals((int)1, (int)training.size());
        Instance inst1 = (Instance)training.get(0);
        LabelsSequence ls1 = (LabelsSequence)inst1.getTarget();
        TestGenericAcrfData2TokenSequence.assertEquals((int)4, (int)ls1.size());
        TokenSequence ts1 = (TokenSequence)inst1.getData();
        TestGenericAcrfData2TokenSequence.assertEquals((int)3, (int)((Token)ts1.get(0)).getFeatures().size());
        TestGenericAcrfData2TokenSequence.assertEquals((int)2, (int)((Token)ts1.get(1)).getFeatures().size());
    }

    public static Test suite() {
        return new TestSuite(TestGenericAcrfData2TokenSequence.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestGenericAcrfData2TokenSequence(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestGenericAcrfData2TokenSequence.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

