/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.tests.TestSerializable;
import java.io.IOException;
import java.io.Serializable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestLabelAlphabet
extends TestCase {
    public TestLabelAlphabet(String name) {
        super(name);
    }

    public void testReadResolve() throws IOException, ClassNotFoundException {
        LabelAlphabet dict = new LabelAlphabet();
        dict.lookupIndex("TEST1");
        dict.lookupIndex("TEST2");
        dict.lookupIndex("TEST3");
        Label t1 = dict.lookupLabel("TEST1");
        Labelee l = new Labelee(dict, t1);
        Labelee l2 = (Labelee)TestSerializable.cloneViaSerialization(l);
        TestLabelAlphabet.assertTrue((l.dict == l2.dict ? 1 : 0) != 0);
        TestLabelAlphabet.assertTrue((dict.lookupLabel("TEST1") == l.theLabel ? 1 : 0) != 0);
        TestLabelAlphabet.assertTrue((dict.lookupLabel("TEST1") == l2.theLabel ? 1 : 0) != 0);
        TestLabelAlphabet.assertTrue((l.theLabel == l2.theLabel ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestLabelAlphabet.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestLabelAlphabet(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestLabelAlphabet.suite();
        }
        TestRunner.run((Test)theSuite);
    }

    private static class Labelee
    implements Serializable {
        LabelAlphabet dict;
        Label theLabel;

        public Labelee(LabelAlphabet dict, Label theLabel) {
            this.dict = dict;
            this.theLabel = theLabel;
        }
    }
}

