% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_read.R
\name{make_read}
\alias{make_read}
\alias{read_matrix}
\alias{read_edgelist}
\alias{read_nodelist}
\alias{read_pajek}
\alias{read_ucinet}
\alias{read_dynetml}
\alias{read_graphml}
\title{Making networks from external files}
\source{
\code{read_ucinet()} kindly supplied by Christian Steglich,
constructed on 18 June 2015.
}
\usage{
read_matrix(file = file.choose(), sv = c("comma", "semi-colon"), ...)

read_edgelist(file = file.choose(), sv = c("comma", "semi-colon"), ...)

read_nodelist(file = file.choose(), sv = c("comma", "semi-colon"), ...)

read_pajek(file = file.choose(), ties = NULL, ...)

read_ucinet(file = file.choose())

read_dynetml(file = file.choose())

read_graphml(file = file.choose())
}
\arguments{
\item{file}{A character string with the system path to the file to import.
If left unspecified, an OS-specific file picker is opened to help users select it.
Note that in \code{read_ucinet()} the file path should be to the header file (.##h),
if it exists and that it is currently not possible to import multiple
networks from a single UCINET file. Please convert these one by one.}

\item{sv}{Allows users to specify whether their csv file is
\code{"comma"} (English) or \code{"semi-colon"} (European) separated.}

\item{...}{Additional parameters passed to the read/write function.}

\item{ties}{A character string indicating the ties/network,
where the data contains several.}
}
\value{
\code{read_edgelist()} and \code{read_nodelist()} will import
into edgelist (tibble) format which can then be coerced or combined into
different graph objects from there.

\code{read_pajek()} and \code{read_ucinet()} will import into
a tidygraph format, since they already contain both edge and attribute data.
\code{read_matrix()} will import into tidygraph format too.
Note that all graphs can be easily coerced into other formats
with \code{{manynet}}'s \code{as_} methods.
}
\description{
Researchers regularly need to work with a variety of external data formats.
The following functions offer ways to import from some common external
file formats into objects that \code{{manynet}} and other graph/network packages
in R can work with:
\itemize{
\item \code{read_matrix()} imports adjacency matrices from Excel/csv files.
\item \code{read_edgelist()} imports edgelists from Excel/csv files.
\item \code{read_nodelist()} imports nodelists from Excel/csv files.
\item \code{read_pajek()} imports Pajek (.net or .paj) files.
\item \code{read_ucinet()} imports UCINET files from the header (.##h).
\item \code{read_dynetml()} imports DyNetML interchange format for rich social network data.
\item \code{read_graphml()} imports GraphML files.
}
}
\details{
Note that these functions are not as actively maintained as others
in the package, so please let us know if any are not currently working
for you or if there are missing import routines
by \href{https://github.com/stocnet/manynet/issues}{raising an issue on Github}.

There are a number of repositories for network data
that hold various datasets in different formats. See for example:
\itemize{
\item \href{https://sites.google.com/site/ucinetsoftware/datasets?authuser=0}{UCINET data}
\item \href{http://vlado.fmf.uni-lj.si/pub/networks/data/}{Pajek data}
\item \href{https://schochastics.github.io/networkdata/}{networkdata}
\item \href{http://www-personal.umich.edu/~mejn/netdata/}{GML datasets}
\item UCIrvine Network Data Repository
\item \href{http://snap.stanford.edu/data/}{SNAP Stanford Large Network Dataset Collection}
}

Please let us know if you identify any further repositories
of social or political networks and we would be happy to add them here.

The \verb{_ucinet} functions only work with relatively recent UCINET
file formats, e.g. type 6406 files.
To import earlier UCINET file types, you will need to update them first.
To import multiple matrices packed into a single UCINET file,
you will need to unpack them and convert them one by one.
}
\seealso{
\link{as}

Other makes: 
\code{\link{make_cran}},
\code{\link{make_create}},
\code{\link{make_explicit}},
\code{\link{make_learning}},
\code{\link{make_play}},
\code{\link{make_random}},
\code{\link{make_stochastic}},
\code{\link{make_write}}
}
\concept{makes}
