% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_centrality.R
\name{measure_central_degree}
\alias{measure_central_degree}
\alias{node_degree}
\alias{node_deg}
\alias{node_outdegree}
\alias{node_indegree}
\alias{node_multidegree}
\alias{node_posneg}
\alias{tie_degree}
\alias{net_degree}
\alias{net_outdegree}
\alias{net_indegree}
\title{Measures of degree-like centrality and centralisation}
\usage{
node_degree(
  .data,
  normalized = TRUE,
  alpha = 1,
  direction = c("all", "out", "in")
)

node_deg(.data, alpha = 0, direction = c("all", "out", "in"))

node_outdegree(.data, normalized = TRUE, alpha = 0)

node_indegree(.data, normalized = TRUE, alpha = 0)

node_multidegree(.data, tie1, tie2)

node_posneg(.data)

tie_degree(.data, normalized = TRUE)

net_degree(.data, normalized = TRUE, direction = c("all", "out", "in"))

net_outdegree(.data, normalized = TRUE)

net_indegree(.data, normalized = TRUE)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}

\item{alpha}{Numeric scalar, the positive tuning parameter introduced in
Opsahl et al (2010) for trading off between degree and strength centrality measures.
By default, \code{alpha = 0}, which ignores tie weights and the measure is solely based
upon degree (the number of ties).
\code{alpha = 1} ignores the number of ties and provides the sum of the tie weights
as strength centrality.
Values between 0 and 1 reflect different trade-offs in the relative contributions of
degree and strength to the final outcome, with 0.5 as the middle ground.
Values above 1 penalise for the number of ties.
Of two nodes with the same sum of tie weights, the node with fewer ties will obtain
the higher score.
This argument is ignored except in the case of a weighted network.}

\item{direction}{Character string, “out” bases the measure on outgoing ties,
“in” on incoming ties, and "all" on either/the sum of the two.
For two-mode networks, "all" uses as numerator the sum of differences
between the maximum centrality score for the mode
against all other centrality scores in the network,
whereas "in" uses as numerator the sum of differences
between the maximum centrality score for the mode
against only the centrality scores of the other nodes in that mode.}

\item{tie1}{Character string indicating the first uniplex network.}

\item{tie2}{Character string indicating the second uniplex network.}
}
\value{
A single centralization score if the object was one-mode,
and two centralization scores if the object was two-mode.

Depending on how and what kind of an object is passed to the function,
the function will return a \code{tidygraph} object where the nodes have been updated
}
\description{
These functions calculate common degree-related centrality measures for one- and two-mode networks:
\itemize{
\item \code{node_degree()} measures the degree centrality of nodes in an unweighted network,
or weighted degree/strength of nodes in a weighted network;
there are several related shortcut functions:
\itemize{
\item \code{node_deg()} returns the unnormalised results.
\item \code{node_indegree()} returns the \code{direction = 'in'} results.
\item \code{node_outdegree()} returns the \code{direction = 'out'} results.
}
\item \code{node_multidegree()} measures the ratio between types of ties in a multiplex network.
\item \code{node_posneg()} measures the PN (positive-negative) centrality of a signed network.
\item \code{tie_degree()} measures the degree centrality of ties in a network
\item \code{net_degree()} measures a network's degree centralization;
there are several related shortcut functions:
\itemize{
\item \code{net_indegree()} returns the \code{direction = 'out'} results.
\item \code{net_outdegree()} returns the \code{direction = 'out'} results.
}
}

All measures attempt to use as much information as they are offered,
including whether the networks are directed, weighted, or multimodal.
If this would produce unintended results,
first transform the salient properties using e.g. \code{\link[=to_undirected]{to_undirected()}} functions.
All centrality and centralization measures return normalized measures by default,
including for two-mode networks.
}
\examples{
node_degree(ison_southern_women)
tie_degree(ison_adolescents)
net_degree(ison_southern_women, direction = "in")
}
\references{
Faust, Katherine. 1997.
"Centrality in affiliation networks."
\emph{Social Networks} 19(2): 157-191.
\doi{10.1016/S0378-8733(96)00300-0}.

Borgatti, Stephen P., and Martin G. Everett. 1997.
"Network analysis of 2-mode data."
\emph{Social Networks} 19(3): 243-270.
\doi{10.1016/S0378-8733(96)00301-2}.

Borgatti, Stephen P., and Daniel S. Halgin. 2011.
"Analyzing affiliation networks."
In \emph{The SAGE Handbook of Social Network Analysis},
edited by John Scott and Peter J. Carrington, 417–33.
London, UK: Sage.
\doi{10.4135/9781446294413.n28}.

Opsahl, Tore, Filip Agneessens, and John Skvoretz. 2010.
"Node centrality in weighted networks: Generalizing degree and shortest paths."
\emph{Social Networks} 32, 245-251.
\doi{10.1016/j.socnet.2010.03.006}

Everett, Martin G., and Stephen P. Borgatti. 2014.
“Networks Containing Negative Ties.”
\emph{Social Networks} 38:111–20.
\doi{10.1016/j.socnet.2014.03.005}.
}
\seealso{
\code{\link[=to_undirected]{to_undirected()}} for removing edge directions
and \code{\link[=to_unweighted]{to_unweighted()}} for removing weights from a graph.

Other centrality: 
\code{\link{measure_central_between}},
\code{\link{measure_central_close}},
\code{\link{measure_central_eigen}}

Other measures: 
\code{\link{measure_attributes}},
\code{\link{measure_central_between}},
\code{\link{measure_central_close}},
\code{\link{measure_central_eigen}},
\code{\link{measure_closure}},
\code{\link{measure_cohesion}},
\code{\link{measure_diffusion_infection}},
\code{\link{measure_diffusion_net}},
\code{\link{measure_diffusion_node}},
\code{\link{measure_features}},
\code{\link{measure_heterogeneity}},
\code{\link{measure_hierarchy}},
\code{\link{measure_holes}},
\code{\link{measure_periods}},
\code{\link{measure_properties}},
\code{\link{member_diffusion}}
}
\concept{centrality}
\concept{measures}
