% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_holes.R
\name{measure_holes}
\alias{measure_holes}
\alias{node_bridges}
\alias{node_redundancy}
\alias{node_effsize}
\alias{node_efficiency}
\alias{node_constraint}
\alias{node_hierarchy}
\alias{node_eccentricity}
\alias{node_neighbours_degree}
\alias{tie_cohesion}
\title{Measures of structural holes}
\usage{
node_bridges(.data)

node_redundancy(.data)

node_effsize(.data)

node_efficiency(.data)

node_constraint(.data)

node_hierarchy(.data)

node_eccentricity(.data)

node_neighbours_degree(.data)

tie_cohesion(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These function provide different measures of the degree to which nodes
fill structural holes, as outlined in Burt (1992):
\itemize{
\item \code{node_bridges()} measures the sum of bridges to which each node
is adjacent.
\item \code{node_redundancy()} measures the redundancy of each nodes' contacts.
\item \code{node_effsize()} measures nodes' effective size.
\item \code{node_efficiency()} measures nodes' efficiency.
\item \code{node_constraint()} measures nodes' constraint scores for one-mode networks
according to Burt (1992) and for two-mode networks according to Hollway et al (2020).
\item \code{node_hierarchy()} measures nodes' exposure to hierarchy,
where only one or two contacts are the source of closure.
\item \code{node_eccentricity()} measures nodes' eccentricity or Koenig number,
a measure of farness based on number of links needed to reach
most distant node in the network.
\item \code{node_neighbours_degree()} measures nodes' average nearest neighbors degree,
or \eqn{knn}, a measure of the type of local environment a node finds itself in
\item \code{tie_cohesion()} measures the ratio between common neighbors to ties'
adjacent nodes and the total number of adjacent nodes,
where high values indicate ties' embeddedness in dense local environments
}

Burt's theory holds that while those nodes embedded in dense clusters
of close connections are likely exposed to the same or similar ideas and information,
those who fill structural holes between two otherwise disconnected groups
can gain some comparative advantage from that position.
}
\details{
A number of different ways of measuring these structural holes are available.
Note that we use Borgatti's reformulation for unweighted networks in
\code{node_redundancy()} and \code{node_effsize()}.
Redundancy is thus \eqn{\frac{2t}{n}},
where \eqn{t} is the sum of ties and \eqn{n} the sum of nodes in each node's neighbourhood,
and effective size is calculated as \eqn{n - \frac{2t}{n}}.
Node efficiency is the node's effective size divided by its degree.
}
\examples{
node_bridges(ison_adolescents)
node_bridges(ison_southern_women)
node_redundancy(ison_adolescents)
node_redundancy(ison_southern_women)
node_effsize(ison_adolescents)
node_effsize(ison_southern_women)
node_efficiency(ison_adolescents)
node_efficiency(ison_southern_women)
node_constraint(ison_southern_women)
node_hierarchy(ison_adolescents)
node_hierarchy(ison_southern_women)
}
\references{
Burt, Ronald S. 1992.
\emph{Structural Holes: The Social Structure of Competition}.
Cambridge, MA: Harvard University Press.

Borgatti, Steven. 1997.
“\href{http://www.analytictech.com/connections/v20(1)/holes.htm}{Structural Holes: Unpacking Burt’s Redundancy Measures}”
\emph{Connections} 20(1):35-38.

Burchard, Jake, and Benjamin Cornwell. 2018.
“Structural Holes and Bridging in Two-Mode Networks.”
\emph{Social Networks} 55:11–20.
\doi{10.1016/j.socnet.2018.04.001}

Hollway, James, Jean-Frédéric Morin, and Joost Pauwelyn. 2020.
"Structural conditions for novelty: the introduction of new environmental clauses to the trade regime complex."
\emph{International Environmental Agreements: Politics, Law and Economics} 20 (1): 61–83.
\doi{10.1007/s10784-019-09464-5}.

Barrat, Alain, Marc Barthelemy, Romualdo Pastor-Satorras, and Alessandro Vespignani. 2004.
"The architecture of complex weighted networks",
\emph{Proc. Natl. Acad. Sci.} 101: 3747.
}
\seealso{
Other measures: 
\code{\link{measure_attributes}},
\code{\link{measure_central_between}},
\code{\link{measure_central_close}},
\code{\link{measure_central_degree}},
\code{\link{measure_central_eigen}},
\code{\link{measure_closure}},
\code{\link{measure_cohesion}},
\code{\link{measure_diffusion_infection}},
\code{\link{measure_diffusion_net}},
\code{\link{measure_diffusion_node}},
\code{\link{measure_features}},
\code{\link{measure_heterogeneity}},
\code{\link{measure_hierarchy}},
\code{\link{measure_periods}},
\code{\link{measure_properties}},
\code{\link{member_diffusion}}
}
\concept{measures}
