% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_states.R
\name{code_states}
\alias{code_states}
\title{Code stateIDs from text}
\usage{
code_states(text, code = TRUE, max_count = 1)
}
\arguments{
\item{text}{A vector of text to search for country names within.}

\item{code}{Logical whether the function should return the three-letter
abbreviation (an extended version of ISO-3166 alpha-3),
or the name of the state.
For the complete list of entities and their search terms,
run the function without an argument (i.e. \code{code_states()}).
Updates and suggestions welcome.}

\item{max_count}{Integer how many countries to search for in each element
of the vector.
Where more than one country is matched, the countries are returned as a set,
i.e. in the format "\{AUS,NZL\}".
By default \code{max_count = 1}, which will just return the first match.}
}
\value{
A character vector of the same length as \code{text},
with either the three-letter abbreviation (an extended version of ISO-3166 alpha-3),
or the name of the state, or \code{NA} where no match was found.
If \code{max_count > 1}, multiple matches are returned as a set,
i.e. in the format "\{AUS,NZL\}".
If the function is run without an argument, it returns
a data frame with the complete list of entities and their search terms.
}
\description{
This function allows for contemporary and historical countries or states
to be identified in text.
It uses a regular expression (regex) to search for
a number of common names and alternative spellings for each entity.
The function returns either the three-letter abbreviation
(an extended version of ISO-3166 alpha-3), or the name of the state.
The function can also return multiple matches, where more than one
country is mentioned in the text.
Currently, the function can identify 500 entities.
Updates, bug reports, and suggestions welcome.
}
\examples{
code_states(c("I went to England",
  "I come from Venezuela",
  "Did you know there was a Lunda Empire?",
  "I like both Australia and New Zealand"))
code_states(c("I went to England",
  "I come from Venezuela",
  "Did you know there was a Lunda Empire?",
  "I like both Australia and New Zealand"), max_count = 2)
}
