% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_getTiles.R
\name{esp_getTiles}
\alias{esp_getTiles}
\title{Get Tiles from Public Administrations of Spanish.}
\source{
\href{https://dieghernan.github.io/leaflet-providersESP/}{leaflet-providersESP}
leaflet plugin, \strong{v1.2.0}.
}
\usage{
esp_getTiles(
  x,
  type = "IDErioja",
  zoom = NULL,
  crop = TRUE,
  res = 512,
  bbox_expand = 0.05,
  transparent = TRUE,
  mask = FALSE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{x}{An \code{sf} object.}

\item{type}{Name of the provider. See \link{leaflet.providersESP.df}.}

\item{zoom}{the zoom level. If \code{NULL}, it is determined automatically
(see \code{\link[cartography]{getTiles}}). Only valid for WMTS.}

\item{crop}{TRUE if results should be cropped to the specified x extent,
FALSE otherwise. If x is an sf object with one POINT, crop is set to FALSE.}

\item{res}{Resolution (in pixels) of the final tile. Only valid for WMS.}

\item{bbox_expand}{A numeric value that indicates the expansion percentage
of the bounding box of \code{x}.}

\item{transparent}{Logical. Provides transparent background, if supported.
Depends on the selected provider on \code{type}.}

\item{mask}{\code{TRUE} if the result should be masked to \code{x}.}

\item{update_cache, cache_dir, verbose}{See \link{esp_get_nuts}}
}
\value{
A RasterBrick is returned.
}
\description{
Get static map tiles based on a spatial object.
Maps can be
fetched from various open map servers.

This function is a implementation of the javascript plugin
\href{https://dieghernan.github.io/leaflet-providersESP/}{leaflet-providersESP}
\strong{v1.2.0}
}
\details{
Results of \code{esp_getTiles} could be plotted using
\code{\link[cartography]{tilesLayer}}

For a complete list of providers see \link{leaflet.providersESP.df}.


Most WMS/WMTS providers provide tiles on EPSG:3857. In case that the tile
looks deformed, try projecting first \code{x}:

\code{x <- sf::st_transform(x,3857)}

Tiles are cached under the path \code{cache_dir/[type]}
}
\seealso{
\link{leaflet.providersESP.df}, \link{addProviderEspTiles},
\link[cartography]{getTiles},
 \link[cartography]{tilesLayer}.
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
