% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_munic.R
\name{esp_get_munic}
\alias{esp_get_munic}
\title{Get municipalities boundaries of Spain}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/}{GISCO API}
}
\usage{
esp_get_munic(
  year = "2019",
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  region = NULL,
  munic = NULL,
  moveCAN = TRUE
)
}
\arguments{
\item{year, epsg, cache, update_cache, cache_dir, verbose, moveCAN}{See \link{esp_get_nuts}. Years from 2016 to 2019 available.}

\item{region}{A vector of names and/or codes for provinces
or \code{NULL} to get all the municipalities. See Details.}

\item{munic}{A name or regex expression with the names of the required
municipalities. \code{NULL} would not produce any filtering.}
}
\value{
A \code{POLYGON} object.
}
\description{
Loads a simple feature (\code{sf}) object containing the
municipalities boundaries of Spain.
}
\details{
When using \code{region} you can use and mix names and NUTS codes
(levels 1, 2 or 3), ISO codes (corresponding to level 2 or 3) or
\code{cpro}.

When calling a superior level (Province, Autonomous Community or NUTS1) ,
all the municipalities of that level would be added.
}
\examples{


library(sf)

Base <- esp_get_munic(region = c("Castilla y Leon"))
SAN <-
  esp_get_munic(
    region = c("Castilla y Leon"),
    munic = c("^San ", "^Santa ")
  )

plot(st_geometry(Base), col = "cornsilk", border = "grey80")
plot(st_geometry(SAN),
     col = "firebrick3",
     border = NA,
     add = TRUE)
}
\seealso{
\link{esp_get_nuts},\link{esp_munic.sf}, \link{esp_codelist}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
