% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbayest_check_and_preprocess.R
\name{preprocess.optim}
\alias{preprocess.optim}
\title{Pre-process: arguments for optimization function}
\usage{
preprocess.optim(
  x,
  method = c("L-BFGS-B", "newuoa"),
  select_eta = NULL,
  control = list(),
  force_initial_eta = NULL,
  quantile_bound = 0.001
)
}
\arguments{
\item{x}{the model object}

\item{method}{optimization method; the default is \code{"L-BFGS-B"} (from \code{stat::optim()}), alternatively \code{"newuoa"} for \code{minqa::newuoa()}}

\item{select_eta}{a vector of numeric values, the numbers of the ETAs to be estimated (default is \code{NULL}, all ETAs non-equal to zero)}

\item{control}{a list passed to the optimizer (see \code{\link[stats:optim]{stats::optim()}} or  \code{\link[minqa:newuoa]{minqa::newuoa()}} documentation)}

\item{force_initial_eta}{a vector of numeric values to start the estimation from (default to 0 for "L-BFGS-B")}

\item{quantile_bound}{a numeric value representing the quantile of the normal distribution admitted to define the bounds for L-BFGS-B (default is 0.001, i.e. 0.1\%)}
}
\value{
a list of named arguments passed to optimizer (i.e. arg.optim)
}
\description{
Pre-process: arguments for optimization function
}
