% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_line.R
\name{add_line}
\alias{add_line}
\title{Add line}
\usage{
add_line(map, data = get_map_data(map), layer_id = NULL, origin,
  destination, id = NULL, stroke_colour = NULL, stroke_width = NULL,
  stroke_opacity = NULL, tooltip = NULL, auto_highlight = FALSE,
  highlight_colour = "#AAFFFFFF", palette = "viridis",
  na_colour = "#808080FF", legend = FALSE, legend_options = NULL,
  legend_format = NULL, update_view = TRUE, focus_layer = FALSE,
  transitions = NULL)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer. All coordinates are expected to be in
Web Mercator Projection}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{origin}{vector of longitude and latitude columns, or an \code{sfc} column}

\item{destination}{vector of longitude and latitude columns, or an \code{sfc} column}

\item{id}{an id value in \code{data} to identify layers when interacting in Shiny apps.}

\item{stroke_colour}{variable or hex colour to use as the ending stroke colour.
transition enabled}

\item{stroke_width}{width of the stroke}

\item{stroke_opacity}{Either a string specifying the
column of \code{data} containing the stroke opacity of each shape, or a value
between 0 and 255 to be applied to all the shapes}

\item{tooltip}{variable of \code{data} containing text or HTML to render as a tooltip}

\item{auto_highlight}{logical indicating if the shape under the mouse should auto-highlight}

\item{highlight_colour}{hex string colour to use for highlighting. Must contain the alpha component.}

\item{palette}{string or matrix. String will be one of \code{colourvalues::colour_palettes()}.
A matrix is a 3 or 4 column numeric matrix of values between [0, 255],
where the 4th column represents the alpha.}

\item{na_colour}{hex string colour to use for NA values}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{legend_format}{A list containing functions to apply to legend values. See section legend}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}

\item{transitions}{list specifying the duration of transitions.}
}
\description{
The Line Layer renders raised lines joining pairs of source and target coordinates
}
\details{
\code{add_line} supports POINT sf objects


MULTIPOINT objects will be treated as single points. That is, if an sf object
has one row with a MULTIPOINT object consisting of two points, this will
be expanded to two rows of single POINTs.
Therefore, if the origin is a MULTIPOINT of two points, and the destination is
a single POINT, the code will error as there will be an uneven number of rows
}
\section{transitions}{


The transitions argument lets you specify the time it will take for the shapes to transition
from one state to the next. Only works in an interactive environment (Shiny)
and on WebGL-2 supported browsers and hardware.

The time is in milliseconds

Available transitions for line

list(
origin = 0,
destination = 0,
stroke_colour = 0,
stroke_width = 0
)
}

\section{legend}{


The \code{legend_options} can be used to control the appearance of the legend.
This should be a named list, where the names are one of
\itemize{
  \item{css - a string of valid \code{css} for controlling the appearance of the legend}
  \item{title - a string to use for the title of the legend}
}

If the layer allows different fill and stroke colours, you can use different options for each. See examples in \link{add_arc}.

The \code{legend_format} can be used to control the format of the values in the legend.
This should be a named list, where the names are one of
\itemize{
  \item{fill_colour}
  \item{stroke_colour}
}

depending on which type of colouring the layer supports.

The list elements must be functions to apply to the values in the legend.
}

\section{id}{


The \code{id} is returned to your R session from an interactive shiny environment
by observing layer clicks. This is useful for returning the data.frame row relating to the
cliked shape.

From within a shiny server you would typically use \code{ observeEvent({input$map_arc_click})},
where 'map' is the map_id supplied to \code{mapdeckOutput()}, and 'arc' is the layer
you are clicking on
}

\examples{
\donttest{

## You need a valid access token from Mapbox
key <- 'abc'

url <- 'https://raw.githubusercontent.com/plotly/datasets/master/2011_february_aa_flight_paths.csv'
flights <- read.csv(url)
flights$id <- seq_len(nrow(flights))
flights$stroke <- sample(1:3, size = nrow(flights), replace = T)

mapdeck( token = key, style = mapdeck_style("dark"), pitch = 45 ) \%>\%
  add_line(
    data = flights
    , layer_id = "line_layer"
    , origin = c("start_lon", "start_lat")
    , destination = c("end_lon", "end_lat")
    , stroke_colour = "airport1"
    , stroke_width = "stroke"
    , auto_highlight = TRUE
 )

## Using a 2-sfc-column sf object
library(sf)

sf_flights <- cbind(
  sf::st_as_sf(flights, coords = c("start_lon", "start_lat"))
  , sf::st_as_sf(flights[, c("end_lon","end_lat")], coords = c("end_lon", "end_lat"))
)

mapdeck(
  token = key
) \%>\%
 add_line(
   data = sf_flights
   , origin = 'geometry'
   , destination = 'geometry.1'
   , layer_id = 'arcs'
   , stroke_colour = "airport1"
)
}

}
