% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_terrain.R
\name{add_terrain}
\alias{add_terrain}
\title{Add terrain}
\usage{
add_terrain(
  map,
  layer_id = NULL,
  elevation_data,
  texture = NULL,
  elevation_decoder = c(1, 0, 0, 0),
  bounds = NULL,
  max_error = 4,
  update_view = TRUE,
  focus_layer = FALSE
)
}
\arguments{
\item{map}{a mapdeck map object}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{elevation_data}{Image URL that encodes height data. When \code{elevation_data}
is a URL template, i.e. a string containing '{x}' and '{y}', it loads terrain tiles on demand
and renders a mesh for each tile. If \code{elevation_data} is an absolute URL, as ingle mesh is used,
and the \code{bounds} argument is required to position it into the world space.}

\item{texture}{Image URL to use as the texture}

\item{elevation_decoder}{Four value used to convert a pixel to elevation in metres. The
values correspond to rScale, gScale, bScale, offset. See details}

\item{bounds}{Four values (\code{ c(left, bottom, right, top) }. bounds of the
image to fit in x,y coordinates into. \code{left} and \code{right} referes to the world
longitude/x at the corresponding side of the image. \code{top} and \code{bottom} refers to
the world latitude/y at the corresponding side of the image. Must be supplied when using
non-tiled \code{elevation_data}}

\item{max_error}{Martini error tolerance in metres, smaller number results in more detailed mesh.}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}
}
\description{
Adds mesh surfaces from height map images
}
\details{
The \code{elevation_decoder} contains four values representing
\itemize{
  \item{rScale - Multiplier of the red channel}
  \item{gScale - Multiplier of the green channel}
  \item{bScale - Multiplier of the blue channel}
  \item{offset - translation of the sum}
}

Each colour channel is a number between [0, 255].
}
\examples{
\donttest{

set_token( "MAPBOX_TOKEN" )
## Digital elevation model from https://www.usgs.gov/
elevation <- 'https://raw.githubusercontent.com/visgl/deck.gl-data/master/website/terrain.png'
texture <- 'https://raw.githubusercontent.com/visgl/deck.gl-data/master/website/terrain-mask.png'
bounds <- c(-122.5233, 37.6493, -122.3566, 37.8159)

mapdeck() \%>\%
  add_terrain(
    , elevation_data = elevation
    , elevation_decoder = c(1,0,0,0)
    , texture = texture
    , bounds = bounds
    , max_error = 1
  )

}

}
