% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_qc.R
\name{map_qc}
\alias{map_qc}
\title{Wrapper function of genetic map cleaning per linkage group.}
\usage{
map_qc(MF.obj, anchors = 3)
}
\arguments{
\item{MF.obj}{A mapfuser object genetics maps loaded and optionally a reference map}

\item{anchors}{Number of minimum overlapping anchors marker between at least one other genetic map. At least 3 are required.}
}
\value{
The input object is returned with filled QC slot containing genetic maps after quality control. Used parameters and inverted or names of removed data are saved to the config slot.
}
\description{
The raw data is first splitted to separate linkage groups if sublinkage groups exist (e.g LG 1.1 and 1.2).
Subsequently a graph is created from the adjacency matrix that counts the number of overlapping markers between the set of genetic maps.
Calculations are performed for each chromosome separately. Taken quality control steps are printed to the console and can be visualised using the plot function.
}
\examples{
\dontshow{
fpath <- system.file("extdata", package="mapfuser")
maps <- list.files(fpath, pattern = "-1", full.names = TRUE)
MF.obj <- read_maps(mapfiles = maps, sep = ",", header = TRUE, type = "delim")
MF.obj <- map_qc(MF.obj)
}
\dontrun{
MF.obj <- map_qc(MF.obj = MF.obj, anchors = 3)
#Graphical overview of how different genetic maps are connected by overlapping markers
plot(MF.obj, which = "mapnetwork", chr = 1) ## Multiple chromosomes not supported
## A minimal spanning tree using the number of anchors as edge weight,
plot(MF.obj, which = "mst", chr = 1)
#Visualize inverted maps
plot(MF.obj, which = "genetic_maps", maps = c("Col-0_Cvi-0.csv","Col-0_Sha.csv"), chr = 1:3)
}
}
\author{
Dennis van Muijen
}
