% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_helpers.R
\name{classification_helpers}
\alias{classification_helpers}
\alias{get_legend_labels}
\alias{get_legend_colors}
\alias{get_breaks}
\alias{print.mapgl_classification}
\alias{print.mapgl_continuous_scale}
\title{Extract information from classification and continuous scale objects}
\usage{
get_legend_labels(
  scale,
  format = "none",
  currency_symbol = "$",
  digits = 2,
  big_mark = ",",
  suffix = "",
  prefix = ""
)

get_legend_colors(scale)

get_breaks(scale)

\method{print}{mapgl_classification}(x, format = "none", ...)

\method{print}{mapgl_continuous_scale}(x, format = "none", ...)
}
\arguments{
\item{scale}{A mapgl_classification or mapgl_continuous_scale object.}

\item{format}{A character string specifying the format type for labels. Options include:
\itemize{
\item "none" (default): No special formatting
\item "currency": Format as currency (e.g., "$1,234")
\item "percent": Format as percentage (e.g., "12.3\%")
\item "scientific": Format in scientific notation (e.g., "1.2e+03")
\item "compact": Format with abbreviated units (e.g., "1.2K", "3.4M")
}}

\item{currency_symbol}{The currency symbol to use when format = "currency". Defaults to "$".}

\item{digits}{The number of decimal places to display. Defaults to 2.}

\item{big_mark}{The character to use as thousands separator. Defaults to ",".}

\item{suffix}{An optional suffix to add to all values (e.g., "km", "mph").}

\item{prefix}{An optional prefix to add to all values (useful for compact currency like "$1.2K").}

\item{x}{A mapgl_classification or mapgl_continuous_scale object to print.}

\item{...}{Additional arguments passed to formatting functions.}
}
\value{
\describe{
\item{get_legend_labels()}{A character vector of formatted legend labels}
\item{get_legend_colors()}{A character vector of colors}
\item{get_breaks()}{A numeric vector of break values}
}
}
\description{
These functions extract different components from mapgl_classification objects
(created by \code{step_equal_interval()}, \code{step_quantile()}, \code{step_jenks()}) and
mapgl_continuous_scale objects (created by \code{interpolate_palette()}).
}
\examples{
\dontrun{
# Texas county income data
library(tidycensus)
tx <- get_acs(geography = "county", variables = "B19013_001",
              state = "TX", geometry = TRUE)

# Classification examples
eq_class <- step_equal_interval("estimate", tx$estimate, n = 4)
labels <- get_legend_labels(eq_class, format = "currency")
colors <- get_legend_colors(eq_class)
breaks <- get_breaks(eq_class)

# Continuous scale examples
scale <- interpolate_palette("estimate", tx$estimate, method = "quantile", n = 5)
labels <- get_legend_labels(scale, format = "compact", prefix = "$")
colors <- get_legend_colors(scale)
}

}
