% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_precipitation_chirps.R
\docType{data}
\name{precipitation_chirps}
\alias{precipitation_chirps}
\title{Calculate precipitation statistics based on CHIRPS}
\format{
A tibble with a column for years, months, absolute rainfall (in mm), rainfall
anomaly (in mm) and one or more columns per selected time-scale for SPI (dimensionless).
}
\description{
This functions allows to calculate precipitation statistics based on the
CHIRPS rainfall estimates. Corresponding to the time-frame of the analysis
of the portfolio, monthly precipitation statistics are calculated. These include
the total rainfall amount, rainfall anomaly against the 1981-2010 climate normal,
and the Standardized Precipitation Index (SPI) which is available for scales
between 1 and 48 months. Th function needs the \code{SPEI} package to be
installed.
The required resources for this indicator are:
\itemize{
\item \link{chirps}
}
}
\details{
The following arguments can be set:
\describe{
\item{scales_spi}{An integer vector indicating the scales for which to calculate the SPI.}
\item{spi_previous_year}{An integer specifying how many previous years to include in
order to fit the SPI. Defaults to 8 years.}
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2010,
    outdir = outdir,
    tmpdir = tempdir(),
    verbose = FALSE
  ) \%>\%
  get_resources("chirps") \%>\%
  calc_indicators("precipitation_chirps",
    engine = "exactextract",
    scales_spi = 3,
    spi_prev_years = 8
  ) \%>\%
  tidyr::unnest(precipitation_chirps)

aoi
}
}
\keyword{indicator}
