% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglogis_logl.R
\name{loglogis_logl}
\alias{loglogis_logl}
\title{A function to calculate the log-likelihood of Log-Logistics model}
\usage{
loglogis_logl(param, x)
}
\arguments{
\item{param}{parameters of Log-Logistics model}

\item{x}{input data for Log-Logistics model}
}
\value{
returns the value of negative log-likelihood of the Log-Logistics model
}
\description{
A function to calculate the log-likelihood of Log-Logistics model
}
\examples{
set.seed(42)
data <-  rgamma(30,3,0.01)

# set some parameters
par_hat <- c(2.6037079185931518, 247.59811806509711) # estimated parameters
param <-  c(log(par_hat[2]),log(par_hat[1])) # input parameters for logl function

# calculate log-likelihood
result <- marp::loglogis_logl(param, data)

# print result
cat("-logl = ", result, "\n")

}
