% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/student_confint.R
\name{student_confint}
\alias{student_confint}
\title{A function to calculate Studentized bootstrap confidence interval}
\usage{
student_confint(
  n,
  B,
  t,
  m,
  BB,
  par_hat,
  mu_hat,
  pr_hat,
  haz_hat,
  weights,
  alpha,
  y,
  best.model,
  which.model = 1
)
}
\arguments{
\item{n}{number of inter-event times}

\item{B}{number of bootstrap samples}

\item{t}{user-specified time intervals (used to compute hazard rate)}

\item{m}{the number of iterations in nlm}

\item{BB}{number of double-bootstrap samples}

\item{par_hat}{estimated parameters}

\item{mu_hat}{estimated mean inter-event times}

\item{pr_hat}{estimated time to event probability}

\item{haz_hat}{estimated hazard rates}

\item{weights}{model weights}

\item{alpha}{significance level}

\item{y}{user-specified time point (used to compute time-to-event probability)}

\item{best.model}{best model based on information criterion (i.e. AIC)}

\item{which.model}{user-specified generating (or true underlying if known) model}
}
\value{
returns list of Studentized bootstrap intervals (including the model-averaged approach).
\describe{
\item{mu_lower_gen}{Lower limit of the studentized bootstrap confidence interval of the estimated mean based on the generating model}
\item{mu_upper_gen}{Upper limit of the studentized bootstrap confidence interval of the estimated mean based on the generating model}
\item{mu_lower_best}{Lower limit of the studentized bootstrap confidence interval of the estimated mean based on the best model}
\item{mu_upper_best}{Upper limit of the studentized bootstrap confidence interval of the estimated mean based on the best model}
\item{pr_lower_gen}{Lower limit of the studentized bootstrap confidence interval of the estimated probabilities  based on the generating model}
\item{pr_upper_gen}{Upper limit of the studentized bootstrap confidence interval of the estimated probabilities  based on the generating model}
\item{pr_lower_best}{Lower limit of the studentized bootstrap confidence interval of the estimated probabilities  based on the best model}
\item{pr_upper_best}{Upper limit of the studentized bootstrap confidence interval of the estimated probabilities  based on the best model}
\item{haz_lower_gen}{Lower limit of the studentized bootstrap confidence interval of the estimated hazard rates  based on the generating model}
\item{haz_upper_gen}{Upper limit of the studentized bootstrap confidence interval of the estimated hazard rates  based on the generating model}
\item{haz_lower_best}{Lower limit of the studentized bootstrap confidence interval of the estimated hazard rates  based on the best model}
\item{haz_upper_best}{Upper limit of the studentized bootstrap confidence interval of the estimated hazard rates  based on the best model}
\item{mu_lower_ma}{Lower limit of model-averaged studentized bootstrap confidence interval of the estimated mean }
\item{mu_upper_ma}{Upper limit of model-averaged studentized bootstrap confidence interval of the estimated mean }
\item{pr_lower_ma}{Lower limit of model-averaged studentized bootstrap confidence interval of the estimated probabilities  }
\item{pr_upper_ma}{Upper limit of model-averaged studentized bootstrap confidence interval of the estimated probabilities  }
\item{haz_lower_ma}{Lower limit of model-averaged studentized bootstrap confidence interval of the estimated hazard rates  }
\item{haz_upper_ma}{Upper limit of model-averaged studentized bootstrap confidence interval of the estimated hazard rates  }
}
}
\description{
A function to calculate Studentized bootstrap confidence interval
}
\examples{
\donttest{
# generate random data
set.seed(42)
data <- rgamma(30, 3, 0.01)

# set some parameters
n <- 30 # sample size
m <- 10 # number of iterations for MLE optimization
t <- seq(100,200,by=10) # time intervals
y <- 304 # cut-off year for estimating probablity
B <- 100 # number of bootstraps
BB <- 100 # number of double bootstraps
par_hat <- c(
  3.41361e-03, 2.76268e+00, 2.60370e+00, 3.30802e+02, 5.48822e+00, 2.92945e+02, NA,
  9.43071e-03, 2.47598e+02, 1.80102e+00, 6.50845e-01, 7.18247e-01)
mu_hat <- c(292.94512, 292.94513, 319.72017, 294.16945, 298.87286, 292.94512)
pr_hat <- c(0.60039, 0.42155, 0.53434, 0.30780, 0.56416, 0.61795)
haz_hat <-   matrix(c(
  -5.67999, -5.67999, -5.67999, -5.67999, -5.67999, -5.67999,
  -5.67999, -5.67999, -5.67999, -5.67999, -5.67999, -6.09420,
  -5.99679, -5.91174, -5.83682, -5.77031, -5.71085, -5.65738,
  -5.60904, -5.56512, -5.52504, -5.48833, -6.09902, -5.97017,
  -5.85769, -5.75939, -5.67350, -5.59856, -5.53336, -5.47683,
  -5.42805, -5.38621, -5.35060, -6.17146, -6.09512, -6.02542,
  -5.96131, -5.90194, -5.84668, -5.79498, -5.74642, -5.70064,
  -5.65733, -5.61624, -5.92355, -5.80239, -5.70475, -5.62524,
  -5.55994, -5.50595, -5.46106, -5.42359, -5.39222, -5.36591,
  -5.34383, -5.79111, -5.67660, -5.58924, -5.52166, -5.46879,
  -5.42707, -5.39394, -5.36751, -5.34637, -5.32946, -5.31596
),length(t),6)
weights <- c(0.00000, 0.21000, 0.02000, 0.55000, 0.00000, 0.22000) # model weights
alpha <- 0.05 # confidence level
y <- 304 # cut-off year for estimating probablity
best.model <- 2
which.model <- 2 # specify the generating model#'

# construct Studentized bootstrap confidence interval
marp::student_confint(
  n,B,t,m,BB,par_hat,mu_hat,pr_hat,haz_hat,weights,alpha,y,best.model,which.model
)
}

}
