/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.variables.scheduling;

import choco.kernel.solver.variables.scheduling.ITimePeriodList;
import gnu.trove.TIntArrayList;
import java.awt.Point;

public final class TimePeriodList
implements ITimePeriodList {
    private final TIntArrayList timePeriods = new TIntArrayList(4);
    private int expendedDuration;

    @Override
    public final void reset() {
        this.timePeriods.resetQuick();
        this.expendedDuration = 0;
    }

    public void addTimeLength(int start, int length) {
        if (!this.timePeriods.isEmpty() && start == this.timePeriods.getQuick(this.timePeriods.size() - 2)) {
            this.timePeriods.setQuick(this.timePeriods.size() - 1, start + length);
        } else {
            this.timePeriods.add(start);
            this.timePeriods.add(start + length);
        }
        this.expendedDuration += length;
    }

    public void addTimePeriod(int start, int end) {
        if (!this.timePeriods.isEmpty() && start == this.getPeriodLast()) {
            this.timePeriods.setQuick(this.timePeriods.size() - 1, end);
        } else {
            this.timePeriods.add(start);
            this.timePeriods.add(end);
        }
        this.expendedDuration += end - start;
    }

    public final TIntArrayList getTimePeriods() {
        return this.timePeriods;
    }

    @Override
    public final int getExpendedDuration() {
        return this.expendedDuration;
    }

    @Override
    public final boolean isEmpty() {
        return this.timePeriods.isEmpty();
    }

    @Override
    public final int getTimePeriodCount() {
        return this.timePeriods.size() / 2;
    }

    @Override
    public final Point getTimePeriod(int i) {
        int offset = 2 * i;
        return new Point(this.timePeriods.get(offset), this.timePeriods.get(offset + 1));
    }

    @Override
    public final int getPeriodFirst() {
        return this.timePeriods.get(0);
    }

    @Override
    public final int getPeriodLast() {
        return this.timePeriods.get(this.timePeriods.size() - 1);
    }

    @Override
    public final int getPeriodStart(int i) {
        return this.timePeriods.get(2 * i);
    }

    @Override
    public final int getPeriodEnd(int i) {
        return this.timePeriods.get(2 * i + 1);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        if (!this.isEmpty()) {
            for (int i = 0; i < this.getTimePeriodCount(); ++i) {
                b.append(this.getPeriodStart(i)).append("-").append(this.getPeriodEnd(i)).append(';');
            }
            b.deleteCharAt(b.length() - 1);
        }
        b.append(']');
        return b.toString();
    }
}

