/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints;

import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ConstraintManager;
import choco.kernel.model.constraints.ExpressionManager;
import choco.kernel.model.variables.VariableManager;
import java.util.HashMap;
import java.util.Map;

public final class ManagerFactory {
    private static final Map<String, VariableManager<?>> VM_MAP = new HashMap();
    private static final Map<String, ExpressionManager> EM_MAP = new HashMap<String, ExpressionManager>();
    private static final Map<String, ConstraintManager<?>> CM_MAP = new HashMap();
    private static final String ERROR_MSG = "Cant load manager by reflection: ";

    private static Object loadManager(String name) {
        try {
            return Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ModelException(ERROR_MSG + name);
        }
        catch (InstantiationException e) {
            throw new ModelException(ERROR_MSG + name);
        }
        catch (IllegalAccessException e) {
            throw new ModelException(ERROR_MSG + name);
        }
    }

    public static VariableManager<?> loadVariableManager(String name) {
        VariableManager vm = VM_MAP.get(name);
        if (vm == null) {
            vm = (VariableManager)ManagerFactory.loadManager(name);
            VM_MAP.put(name, vm);
        }
        return vm;
    }

    public static ExpressionManager loadExpressionManager(String name) {
        ExpressionManager em = EM_MAP.get(name);
        if (em == null) {
            em = (ExpressionManager)ManagerFactory.loadManager(name);
            EM_MAP.put(name, em);
        }
        return em;
    }

    public static ConstraintManager<?> loadConstraintManager(String name) {
        ConstraintManager cm = CM_MAP.get(name);
        if (cm == null) {
            cm = (ConstraintManager)ManagerFactory.loadManager(name);
            CM_MAP.put(name, cm);
        }
        return cm;
    }

    public static void clear() {
        VM_MAP.clear();
        EM_MAP.clear();
        CM_MAP.clear();
    }
}

