% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/toptradingcycle.R
\name{toptrading.checkStability}
\alias{toptrading.checkStability}
\title{Check if there are any pairs of agents who would rather swap houses with
each other rather than be with their own two current respective partners.}
\usage{
toptrading.checkStability(utils = NULL, pref = NULL, matchings)
}
\arguments{
\item{utils}{is a matrix with cardinal utilities of all individuals in the
market. If there are \code{n} individuals, then this matrix will be of
dimension \code{n} by \code{n}. The \code{i,j}th element refers to the
payoff that individual \code{j} receives from being matched to individual
\code{i}.}

\item{pref}{is a matrix with the preference order of all individuals in the
market. This argument is only required when \code{utils} is not provided.
If there are \code{n} individuals, then this matrix will be of dimension
\code{n} by \code{n}. The \code{i,j}th element refers to \code{j}'s
\code{i}th most favorite partner. Preference orders can either be specified
using R-indexing (starting at 1) or C++ indexing (starting at 0).}

\item{matchings}{is a vector of length \code{n} corresponding to the
matchings being made, so that e.g. if the \code{4}th element is \code{6}
then agent \code{4} was matched to agent \code{6}.}
}
\value{
true if the matching is stable, false otherwise
}
\description{
Check if there are any pairs of agents who would rather swap houses with
each other rather than be with their own two current respective partners.
}
\examples{
pref = matrix(c(2, 4, 3, 4,
                3, 3, 4, 2,
                4, 2, 2, 1,
                1, 1, 1, 3), byrow = TRUE, nrow = 4)
pref
results = toptrading(pref = pref)
results
toptrading.checkStability(pref = pref, matchings = results)
}

