rowMads <- function(x, centers=NULL, constant=1.4826, ...) {
  if (is.null(centers)) {
    centers <- rowMedians(x, ...);
  }
  x <- x - centers;
  x <- abs(x);
  x <- rowMedians(x, ...);
  x <- constant*x;
  x;
} # rowMads()


colMads <- function(x, centers=NULL, constant=1.4826, ...) {
  if (is.null(centers)) {
    centers <- colMedians(x, ...)
  }
  x <- x - centers;
  x <- abs(x);
  x <- colMedians(x, ...);
  x <- constant*x;
  x;
} # colMads()

############################################################################
# HISTORY:
# 2011-11-11 [HB]
# o Dropped the previously introduced expansion of 'center' in rowMads()
#   and colMads().  It added unnecessary overhead if not needed.
# 2011-10-13 [HJ]
# o Implemented colMads() as rowMads() by using the improved colMedians().
# o Now rowMads() expands 'center' to a matrix of the same dimensions as
#   'x'.  This is not actually necessary, but it enforces that 'x' must be
#   a matrix.
# 2008-03-26 [HB] 
# o Created.
############################################################################
