% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3b.miph.R
\name{cdf,miph-method}
\alias{cdf,miph-method}
\title{Distribution Method for multivariate inhomogeneous phase-type distributions}
\usage{
\S4method{cdf}{miph}(x, y, lower.tail = TRUE)
}
\arguments{
\item{x}{An object of class \linkS4class{miph}.}

\item{y}{A matrix of observations.}

\item{lower.tail}{Logical parameter specifying whether lower tail (cdf) or upper tail is computed.}
}
\value{
A list containing the locations and corresponding CDF evaluations.
}
\description{
Distribution Method for multivariate inhomogeneous phase-type distributions
}
\examples{
under_mph <- mph(structure = c("general", "general"))
obj <- miph(under_mph, gfun = c("weibull", "pareto"), gfun_pars = list(c(2), c(3)))
cdf(obj, c(1, 2))
}
