% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.postestimation.R
\name{cr}
\alias{cr}
\title{Composite Reliability indices for matrixpls results}
\usage{
cr(object, ...)
}
\arguments{
\item{object}{matrixpls estimation result object produced by the \code{\link{matrixpls}} function.}

\item{...}{All other arguments are ignored.}
}
\value{
A named numeric vector containing the Composite Reliability indices.
}
\description{
The \code{matrixpls} method for the generic function \code{cr} computes Composite Reliability 
indices for the model using the formula presented by Fornell and Larcker (1981).
}
\references{
Fornell, C., & Larcker, D. F. (1981). Evaluating structural equation models with unobservable variables and measurement error. \emph{Journal of marketing research}, 18(1), 39–50.

Aguirre-Urreta, M. I., Marakas, G. M., & Ellis, M. E. (2013). Measurement of composite reliability in research using partial least squares: Some issues and an alternative approach. \emph{The DATA BASE for Advances in Information Systems}, 44(4), 11–43. \href{http://doi.org/10.1145/2544415.2544417}{DOI:10.1145/2544415.2544417}
}
\seealso{
Other post-estimation functions: \code{\link{ave}},
  \code{\link{effects.matrixpls}},
  \code{\link{fitSummary}}, \code{\link{fitted.matrixpls}},
  \code{\link{gof}}, \code{\link{htmt}},
  \code{\link{loadings.matrixpls}},
  \code{\link{predict.matrixpls}}, \code{\link{r2}},
  \code{\link{residuals.matrixpls}}
}

