% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.inner.R
\name{innerEstimators}
\alias{inner.centroid}
\alias{inner.factor}
\alias{inner.gsca}
\alias{inner.identity}
\alias{inner.path}
\alias{innerEstimators}
\title{PLS inner estimation}
\usage{
inner.centroid(S, W, inner.mod, ignoreInnerModel = FALSE, ...)

inner.path(S, W, inner.mod, ...)

inner.factor(S, W, inner.mod, ignoreInnerModel = FALSE, ...)

inner.identity(S, W, inner.mod, ...)

inner.gsca(S, W, inner.mod, ...)
}
\arguments{
\item{S}{Covariance matrix of the data.}

\item{W}{Weight matrix, where the indicators are on colums and composites are on the rows.}

\item{inner.mod}{A square matrix specifying the relationships of the composites in the model.}

\item{ignoreInnerModel}{Should the inner model be ignored and all correlations be used.}

\item{...}{Other arguments are ignored.}
}
\value{
A matrix of unscaled inner weights \code{E} with the same dimesions as \code{inner.mod}.
}
\description{
Calculates a set of inner weights.
}
\details{
In the centroid scheme, inner weights are set to the signs (1 or -1) of correlations between
composites that are connected in the model specified in \code{inner.mod} and zero otherwise.

In the path scheme, inner weights are based on regression estimates of the relationships between
composites that are connected in the model specified in \code{inner.mod}, and correlations for
the inverse relationships. If a relationship is reciprocal, regression is used for both directions.

In the factor scheme, inner weights are set to the correlations between
composites that are connected in the model specified in \code{inner.mod} and zero otherwise.

In the identity scheme identity matrix is used as the inner weight matrix \code{E}.

Centroid, innner, and path schemes fall back to to identity scheme for composites 
that are not connected to any other composites.

For information about GSCA weights, see \link{GSCA}.
}
\section{Functions}{
\itemize{
\item \code{inner.centroid}: inner estimation with centroid scheme.

\item \code{inner.path}: inner estimation with path scheme.

\item \code{inner.factor}: inner estimation with factor scheme.

\item \code{inner.identity}: inner estimation with identity scheme.

\item \code{inner.gsca}: inner estimation with generalized structured component analysis.
}}
\references{
Lohmöller J.-B. (1989) \emph{Latent variable path modeling with partial least squares.} Heidelberg: Physica-Verlag.
}

