% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.R
\name{matrixpls}
\alias{matrixpls}
\title{Partial Least Squares and other composite variable models.}
\usage{
matrixpls(S, model, W.model = NULL, weightFun = weightFun.pls,
  parameterEstim = parameterEstim.separate, weightSign = NULL, ...,
  validateInput = TRUE, standardize = TRUE)
}
\arguments{
\item{S}{Covariance matrix of the data.}

\item{model}{There are two options for this argument: 1. lavaan script or lavaan parameter
table, or 2. a list containing three matrices
\code{inner}, \code{reflective}, and \code{formative} defining the free regression paths
in the model.}

\item{W.model}{An optional numeric matrix representing the weight pattern and starting weights
(i.e. the how the indicators are combined to form the composite variables). If this argument is not specified,
the weight patter is defined based on the relationships in the \code{reflective} and  \code{formative}
elements of \code{model}.}

\item{weightFun}{A function for calculating indicator weights using the data covariance matrix
\code{S}, a model specification \code{model}, and a weight pattern \code{W.model}. Returns
a weigth matrix \code{W}. The default is \code{\link{weightFun.pls}}}

\item{parameterEstim}{A function for estimating the model parameters using
the data covariance matrix \code{S}, model specification \code{model}, 
and weight matrix \code{W}. Returns a named vector of parameter estimates.
The default is \code{\link{parameterEstim.separate}}}

\item{weightSign}{A function for resolving weight sign ambiquity based on the data covariance matrix
\code{S} and a weight matrix \code{W}.  Returns
a weigth matrix \code{W}. See \code{\link{weightSign}}
for details.}

\item{...}{All other arguments are passed through to \code{weightFun} and \code{parameterEstim}.}

\item{validateInput}{If \code{TRUE}, the arguments are validated.}

\item{standardize}{If \code{TRUE}, \code{S} is converted to a correlation matrix before analysis.}
}
\value{
A named numeric vector of class \code{matrixpls} containing the parameter estimates followed by weights.

\code{matrixpls} returns the following as attributes:

\item{W}{the weight matrix.}
\item{model}{the model specification in native format.}
\item{call}{the function call.}

Additionally, all attributes returned by functions called by matrixpls are returned.
This can include:
\item{S}{the sample covariance matrix.}
\item{E}{inner weight matrix.}
\item{iterations}{the number of iterations used by the weight algorithm.}
\item{converged}{\code{TRUE} if the weight algorithm converged and \code{FALSE} otherwise.}
\item{history}{weight optimization history as a matrix.}
\item{C}{the composite correlation matrix (after disattenuation, if requested).}
\item{IC}{the indicator-composite covariance matrix (after disattenuation, if requested).}
\item{inner}{the \code{inner} model matrix with estimated parameters.}
\item{reflective}{the \code{reflective} model matrix with estimated parameters.}
\item{formative}{the \code{formative} model matrix with estimated parameters.}
\item{Q}{the reliability estimates used in dissattenuation.}
\item{c}{the PLSc loading estimate correction factors.}
}
\description{
Estimates a weight matrix using Partial Least Squares or a related algorithm and then
uses the weights to estimate the parameters of a statistical model.
}
\details{
\code{matrixpls} is the main function of the matrixpls package. This function
parses a model object and then uses the results to call \code{weightFun} to
to calculate indicator weight. After this the \code{parameterEstim} function is
applied to the indicator weights, the data covariance matrix,
and the model object and the resulting parameter estimates are returned.

Model can be specified in the lavaan format or the native matrixpls format.
The native model format is a list of three binary matrices, \code{inner}, \code{reflective},
and \code{formative} specifying the free parameters of a model: \code{inner} (\code{l x l}) specifies the 
regressions between composites, \code{reflective} (\code{k x l}) specifies the regressions of observed
data on composites, and \code{formative} (\code{l x k}) specifies the regressions of composites on the
observed data. Here \code{k} is the number of observed variables and \code{l} is the number of composites.

If the model is specified in lavaan format, the native
format model is derived from this model by assigning all regressions between latent
variables to \code{inner}, all factor loadings to \code{reflective}, and all regressions
of latent variables on observed variables to \code{formative}. Regressions between
observed variables and all free covariances are ignored. All parameters that are
specified in the model will be treated as free parameters.

The original papers about Partial Least Squares, as well as many of the current PLS
implementations, impose restrictions on the matrices \code{inner},
\code{reflective}, and \code{formative}: \code{inner} must be a lower triangular matrix,
\code{reflective} must have exactly one non-zero value on each row and must have at least
one non-zero value on each column, and \code{formative} must only contain zeros.
Some PLS implementations allow \code{formative} to contain non-zero values, but impose a
restriction that the sum of \code{reflective} and \code{t(formative)} must satisfy
the original restrictions of \code{reflective}. The only restrictions that matrixpls
imposes on \code{inner}, \code{reflective}, and \code{formative} is that these must be
binary matrices and that the diagonal of \code{inner} must be zeros.

The argument \code{W.model} is a (\code{l x k}) matrix that indicates
how the indicators are combined to form the composites. The original papers about
Partial Least Squares as well as all current PLS implementations define this as
\code{t(reflective) | formative}, which means that the weight patter must match the
model specified in \code{reflective} and \code{formative}. Matrixpls does not
require that \code{W.model} needs to match \code{reflective} and \code{formative}, but
accepts any numeric matrix. If this argument is not specified, all elements of \code{W.model} that
correspond to non-zero elements in the \code{reflective} or \code{formative} formative
matrices receive the value 1.
}
\references{
Rosseel, Y. (2012). lavaan: An R Package for Structural Equation Modeling. \emph{Journal of Statistical Software}, 48(2), 1–36. Retrieved from http://www.jstatsoft.org/v48/i02

Wold, H. (1982). Soft modeling - The Basic Design And Some Extensions. In K. G. Jöreskog & S. Wold (Eds.),\emph{Systems under indirect observation: causality, structure, prediction} (pp. 1–54). Amsterdam: North-Holland.
}
\seealso{
Weight algorithms: \code{\link{weightFun.pls}}; \code{\link{weightFun.fixed}}; \code{\link{weightFun.optim}}; \code{\link{weightFun.principal}}; \code{\link{weightFun.factor}}

Weight sign corrections:\code{\link{weightSign.Wold1985}}; \code{\link{weightSign.dominantIndicator}}

Parameter estimators: \code{\link{parameterEstim.separate}}
}

