% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{iszero_byname}
\alias{iszero_byname}
\title{Test whether this is the zero matrix}
\usage{
iszero_byname(a, tol = 1e-06)
}
\arguments{
\item{a}{A matrix or list of matrices.}

\item{tol}{The allowable deviation from 0 for any element.
Interpreted as an absolute value.}
}
\value{
\code{TRUE} Iff this is the zero matrix within \code{tol}.
}
\description{
Note that this function tests whether the elements of \code{abs(a)} are \verb{<= tol}.
The default value for \code{tol} is \code{1e-6}.
So, you can set \code{tol = 0} to discover if \code{a} is EXACTLY the zero matrix.
}
\examples{
zero <- matrix(0, nrow = 50, ncol = 50)
iszero_byname(zero)
nonzero <- matrix(1:4, nrow = 2)
iszero_byname(nonzero)
# Also works for lists
iszero_byname(list(zero, nonzero))
# And it works for data frames
DF <- data.frame(A = I(list()), B = I(list()))
DF[[1,"A"]] <- zero
DF[[2,"A"]] <- nonzero
DF[[1,"B"]] <- nonzero
DF[[2,"B"]] <- zero
iszero_byname(DF$A)
iszero_byname(DF$B)
iszero_byname(matrix(1e-10, nrow = 2))
iszero_byname(matrix(1e-10, nrow = 2), tol = 1e-11)
}
