% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read.Tree.R
\name{Read.Tree}
\alias{Read.Tree}
\title{Evaluate utilities}
\usage{
Read.Tree(file, skip, nrows)
}
\arguments{
\item{file}{input file}

\item{skip}{starting row for read}

\item{nrows}{number of rows to be readed}
}
\value{
data.table with utilities
}
\description{
The tree structure for the MAUT is extracted from a file with a given format.
}
\examples{
library( data.table )
library( igraph )
file<-system.file("extdata", "tree.csv", package = "mau" )
sheetIndex<-1
tree.data<-Read.Tree( file, skip = 0, nrows = 8 )
}
\author{
Pedro Guarderas, Andrés Lopez
}
\seealso{
\code{\link{Read.Utilities}}, \code{\link{Make.Decision.Tree}}
}

