% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smd_test.R
\name{smd_test}
\alias{smd_test}
\title{Standardized Mean Difference Test}
\usage{
smd_test(x, y, paired = c(TRUE, FALSE), conf.int, mu)
}
\arguments{
\item{x, y}{numeric vectors of data values}

\item{paired}{(character) logical indicator specifying if \code{x} and \code{y} are paired \code{(TRUE)} or independent \code{(FALSE)}}

\item{conf.int}{(optional) confidence level of the interval. Defaults to \code{0.90}}

\item{mu}{(optional) number indicating true difference in means to test against. Defaults to zero.}
}
\value{
Associated effect size measures (\emph{d}, \emph{r}, odds ratio) and respective confidence intervals based upon which statistical test(s) performed.
}
\description{
Performs two-sample difference of means analysis to produce magnitude-based inferences. Evaluates both normality and homoscedasticity, performs either t-test or wilcoxon test, computes effect sizes and estimates magnitude-based inferences. Allows both independent and paired designs.
}
\details{
Refer to vignette for further information.
}
\examples{
a <- rnorm(25, 80, 35)
b <- rnorm(25, 100, 50)

smd_test(a, b, paired = FALSE, 0.95)
}
